/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericIntType<T extends GenericIntType<T>>
extends IntegerTypeImpl<T> {
    final DirectAccessContainer<T, ? extends IntAccess> storage;
    IntAccess b;

    public GenericIntType(DirectAccessContainer<T, ? extends IntAccess> directAccessContainer) {
        this.storage = directAccessContainer;
    }

    public GenericIntType(int n) {
        this.storage = null;
        this.b = new IntArray(1);
        this.setValue(n);
    }

    public GenericIntType() {
        this(0);
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.b = this.storage.update(cursor);
    }

    protected int getValue() {
        return this.b.getValue(this.i);
    }

    protected void setValue(int n) {
        this.b.setValue(this.i, n);
    }

    @Override
    public void mul(float f) {
        int n = this.getValue();
        this.setValue(Util.round((float)n * f));
    }

    @Override
    public void mul(double d) {
        int n = this.getValue();
        this.setValue((int)Util.round((double)n * d));
    }

    @Override
    public void add(T t) {
        int n = this.getValue();
        this.setValue(n + ((GenericIntType)t).getValue());
    }

    @Override
    public void div(T t) {
        int n = this.getValue();
        this.setValue(n / ((GenericIntType)t).getValue());
    }

    @Override
    public void mul(T t) {
        int n = this.getValue();
        this.setValue(n * ((GenericIntType)t).getValue());
    }

    @Override
    public void sub(T t) {
        int n = this.getValue();
        this.setValue(n - ((GenericIntType)t).getValue());
    }

    @Override
    public int compareTo(T t) {
        int n;
        int n2 = this.getValue();
        if (n2 > (n = ((GenericIntType)t).getValue())) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T t) {
        this.setValue(((GenericIntType)t).getValue());
    }

    @Override
    public void setOne() {
        this.setValue(1);
    }

    @Override
    public void setZero() {
        this.setValue(0);
    }

    @Override
    public void inc() {
        int n = this.getValue();
        this.setValue(++n);
    }

    @Override
    public void dec() {
        int n = this.getValue();
        this.setValue(--n);
    }

    @Override
    public String toString() {
        return "" + this.getValue();
    }
}

