/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericByteType<T extends GenericByteType<T>>
extends IntegerTypeImpl<T> {
    final DirectAccessContainer<T, ? extends ByteAccess> storage;
    ByteAccess b;

    public GenericByteType(DirectAccessContainer<T, ? extends ByteAccess> directAccessContainer) {
        this.storage = directAccessContainer;
    }

    protected GenericByteType(byte by) {
        this.storage = null;
        this.b = new ByteArray(1);
        this.setValue(by);
    }

    protected GenericByteType() {
        this(0);
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.b = this.storage.update(cursor);
    }

    protected byte getValue() {
        return this.b.getValue(this.i);
    }

    protected void setValue(byte by) {
        this.b.setValue(this.i, by);
    }

    @Override
    public void mul(float f) {
        byte by = this.getValue();
        this.setValue((byte)Util.round((float)by * f));
    }

    @Override
    public void mul(double d) {
        byte by = this.getValue();
        this.setValue((byte)Util.round((double)by * d));
    }

    @Override
    public void add(T t) {
        byte by = this.getValue();
        this.setValue((byte)(by + ((GenericByteType)t).getValue()));
    }

    @Override
    public void div(T t) {
        byte by = this.getValue();
        this.setValue((byte)(by / ((GenericByteType)t).getValue()));
    }

    @Override
    public void mul(T t) {
        byte by = this.getValue();
        this.setValue((byte)(by * ((GenericByteType)t).getValue()));
    }

    @Override
    public void sub(T t) {
        byte by = this.getValue();
        this.setValue((byte)(by - ((GenericByteType)t).getValue()));
    }

    @Override
    public int compareTo(T t) {
        byte by;
        byte by2 = this.getValue();
        if (by2 > (by = ((GenericByteType)t).getValue())) {
            return 1;
        }
        if (by2 < by) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T t) {
        this.setValue(((GenericByteType)t).getValue());
    }

    @Override
    public void setOne() {
        this.setValue((byte)1);
    }

    @Override
    public void setZero() {
        this.setValue((byte)0);
    }

    @Override
    public void inc() {
        byte by = this.getValue();
        by = (byte)(by + 1);
        this.setValue(by);
    }

    @Override
    public void dec() {
        byte by = this.getValue();
        by = (byte)(by - 1);
        this.setValue(by);
    }

    @Override
    public String toString() {
        return "" + this.getValue();
    }
}

