/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.complex;

import mpicbg.imglib.algorithm.Precision;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.ComplexTypePowerSpectrumDisplay;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.TypeImpl;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexTypeImpl<T extends ComplexTypeImpl<T>>
extends TypeImpl<T>
implements ComplexType<T> {
    int realI = 0;
    int complexI = 1;

    @Override
    public int getEntitiesPerPixel() {
        return 2;
    }

    @Override
    public Display<T> getDefaultDisplay(Image<T> image) {
        return new ComplexTypePowerSpectrumDisplay<T>(image);
    }

    @Override
    public void set(T t) {
        this.setReal(t.getRealDouble());
        this.setComplex(t.getComplexDouble());
    }

    @Override
    public void mul(float f) {
        this.setReal(this.getRealFloat() * f);
        this.setComplex(this.getComplexFloat() * f);
    }

    @Override
    public void mul(double d) {
        this.setReal(this.getRealDouble() * d);
        this.setComplex(this.getComplexDouble() * d);
    }

    @Override
    public void add(T t) {
        this.setReal(this.getRealDouble() + t.getRealDouble());
        this.setComplex(this.getComplexDouble() + t.getComplexDouble());
    }

    @Override
    public void div(T t) {
        double d = this.getRealDouble();
        double d2 = this.getComplexDouble();
        double d3 = t.getRealDouble();
        double d4 = t.getComplexDouble();
        this.setReal((d * d3 + d2 * d4) / (d3 * d3 + d4 * d4));
        this.setComplex((d2 * d3 - d * d4) / (d3 * d3 + d4 * d4));
    }

    @Override
    public void mul(T t) {
        double d = this.getRealDouble();
        double d2 = this.getComplexDouble();
        double d3 = t.getRealDouble();
        double d4 = t.getComplexDouble();
        this.setReal(d * d3 - d2 * d4);
        this.setComplex(d * d4 + d2 * d3);
    }

    @Override
    public void sub(T t) {
        this.setReal(this.getRealDouble() - t.getRealDouble());
        this.setComplex(this.getComplexDouble() - t.getComplexDouble());
    }

    @Override
    public void complexConjugate() {
        this.setComplex(-this.getComplexDouble());
    }

    @Override
    public float getPowerFloat() {
        float f = this.getRealFloat();
        float f2 = this.getComplexFloat();
        return (float)Util.gLog(Math.sqrt(f * f + f2 * f2), 2.0);
    }

    @Override
    public double getPowerDouble() {
        double d = this.getRealDouble();
        double d2 = this.getComplexDouble();
        return Util.gLog(Math.sqrt(d * d + d2 * d2), 2.0);
    }

    @Override
    public float getPhaseFloat() {
        float f = this.getRealFloat();
        float f2 = this.getComplexFloat();
        if ((double)f != 0.0 || f2 != 0.0f) {
            return (float)Math.atan2(f2, f);
        }
        return 0.0f;
    }

    @Override
    public double getPhaseDouble() {
        double d = this.getRealDouble();
        double d2 = this.getComplexDouble();
        if (d != 0.0 || d2 != 0.0) {
            return (float)Math.atan2(d2, d);
        }
        return 0.0;
    }

    @Override
    public void setOne() {
        this.setReal(1.0f);
        this.setComplex(0.0f);
    }

    @Override
    public void setZero() {
        this.setReal(0.0f);
        this.setComplex(0.0f);
    }

    @Override
    public void setComplexNumber(float f, float f2) {
        this.setReal(f);
        this.setComplex(f2);
    }

    @Override
    public void setComplexNumber(double d, double d2) {
        this.setReal(d);
        this.setComplex(d2);
    }

    @Override
    public Precision.PrecisionReal getPreferredRealPrecision() {
        return Precision.PrecisionReal.Double;
    }

    @Override
    public void updateIndex(int n) {
        this.i = n;
        this.realI = n * 2;
        this.complexI = n * 2 + 1;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.realI += 2;
        this.complexI += 2;
    }

    @Override
    public void incIndex(int n) {
        this.i += n;
        int n2 = 2 * n;
        this.realI += n2;
        this.complexI += n2;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.realI -= 2;
        this.complexI -= 2;
    }

    @Override
    public void decIndex(int n) {
        this.i -= n;
        int n2 = 2 * n;
        this.realI -= n2;
        this.complexI -= n2;
    }

    @Override
    public String toString() {
        return "(" + this.getRealDouble() + ") + (" + this.getComplexDouble() + ")i";
    }
}

