/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.complex;

import mpicbg.imglib.algorithm.Precision;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.FloatAccess;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.type.numeric.complex.ComplexTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexFloatType
extends ComplexTypeImpl<ComplexFloatType>
implements ComplexType<ComplexFloatType> {
    final DirectAccessContainer<ComplexFloatType, ? extends FloatAccess> storage;
    FloatAccess b;

    public ComplexFloatType(DirectAccessContainer<ComplexFloatType, ? extends FloatAccess> directAccessContainer) {
        this.storage = directAccessContainer;
    }

    public ComplexFloatType(float f, float f2) {
        this.storage = null;
        this.b = new FloatArray(2);
        this.set(f, f2);
    }

    public ComplexFloatType() {
        this(0.0f, 0.0f);
    }

    @Override
    public DirectAccessContainer<ComplexFloatType, ? extends FloatAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<ComplexFloatType, FloatAccess> directAccessContainer = directAccessContainerFactory.createFloatInstance(nArray, 2);
        ComplexFloatType complexFloatType = new ComplexFloatType(directAccessContainer);
        directAccessContainer.setLinkedType(complexFloatType);
        return directAccessContainer;
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.b = this.storage.update(cursor);
    }

    @Override
    public ComplexFloatType duplicateTypeOnSameDirectAccessContainer() {
        return new ComplexFloatType(this.storage);
    }

    @Override
    public float getRealFloat() {
        return this.b.getValue(this.realI);
    }

    @Override
    public double getRealDouble() {
        return this.b.getValue(this.realI);
    }

    @Override
    public float getComplexFloat() {
        return this.b.getValue(this.complexI);
    }

    @Override
    public double getComplexDouble() {
        return this.b.getValue(this.complexI);
    }

    @Override
    public void setReal(float f) {
        this.b.setValue(this.realI, f);
    }

    @Override
    public void setReal(double d) {
        this.b.setValue(this.realI, (float)d);
    }

    @Override
    public void setComplex(float f) {
        this.b.setValue(this.complexI, f);
    }

    @Override
    public void setComplex(double d) {
        this.b.setValue(this.complexI, (float)d);
    }

    @Override
    public Precision.PrecisionReal getPreferredRealPrecision() {
        return Precision.PrecisionReal.Float;
    }

    public void set(float f, float f2) {
        this.b.setValue(this.realI, f);
        this.b.setValue(this.complexI, f2);
    }

    @Override
    public void add(ComplexFloatType complexFloatType) {
        this.setReal(this.getRealFloat() + complexFloatType.getRealFloat());
        this.setComplex(this.getComplexFloat() + complexFloatType.getComplexFloat());
    }

    @Override
    public void div(ComplexFloatType complexFloatType) {
        float f = this.getRealFloat();
        float f2 = this.getComplexFloat();
        float f3 = complexFloatType.getRealFloat();
        float f4 = complexFloatType.getComplexFloat();
        this.setReal((f * f3 + f2 * f4) / (f3 * f3 + f4 * f4));
        this.setComplex((f2 * f3 - f * f4) / (f3 * f3 + f4 * f4));
    }

    @Override
    public void mul(ComplexFloatType complexFloatType) {
        float f = this.getRealFloat();
        float f2 = this.getComplexFloat();
        float f3 = complexFloatType.getRealFloat();
        float f4 = complexFloatType.getComplexFloat();
        this.setReal(f * f3 - f2 * f4);
        this.setComplex(f * f4 + f2 * f3);
    }

    @Override
    public void sub(ComplexFloatType complexFloatType) {
        this.setReal(this.getRealFloat() - complexFloatType.getRealFloat());
        this.setComplex(this.getComplexFloat() - complexFloatType.getComplexFloat());
    }

    @Override
    public void complexConjugate() {
        this.setComplex(-this.getComplexFloat());
    }

    public void switchRealComplex() {
        float f = this.getRealFloat();
        this.setReal(this.getComplexFloat());
        this.setComplex(f);
    }

    @Override
    public void set(ComplexFloatType complexFloatType) {
        this.setReal(complexFloatType.getRealFloat());
        this.setComplex(complexFloatType.getComplexFloat());
    }

    public ComplexFloatType[] createArray1D(int n) {
        return new ComplexFloatType[n];
    }

    public ComplexFloatType[][] createArray2D(int n, int n2) {
        return new ComplexFloatType[n][n2];
    }

    public ComplexFloatType[][][] createArray3D(int n, int n2, int n3) {
        return new ComplexFloatType[n][n2][n3];
    }

    @Override
    public ComplexFloatType createVariable() {
        return new ComplexFloatType(0.0f, 0.0f);
    }

    @Override
    public ComplexFloatType copy() {
        return new ComplexFloatType(this.getRealFloat(), this.getComplexFloat());
    }
}

