/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.logic;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.BitTypeDisplay;
import mpicbg.imglib.type.BooleanType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitType
extends IntegerTypeImpl<BitType>
implements BooleanType<BitType>,
RealType<BitType> {
    final DirectAccessContainer<BitType, ? extends BitAccess> storage;
    BitAccess b;

    public BitType(DirectAccessContainer<BitType, ? extends BitAccess> directAccessContainer) {
        this.storage = directAccessContainer;
    }

    public BitType(boolean bl) {
        this.storage = null;
        this.b = new BitArray(1);
        this.b.setValue(this.i, bl);
    }

    public BitType() {
        this(false);
    }

    @Override
    public DirectAccessContainer<BitType, ? extends BitAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<BitType, BitAccess> directAccessContainer = directAccessContainerFactory.createBitInstance(nArray, 1);
        BitType bitType = new BitType(directAccessContainer);
        directAccessContainer.setLinkedType(bitType);
        return directAccessContainer;
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.b = this.storage.update(cursor);
    }

    @Override
    public BitType duplicateTypeOnSameDirectAccessContainer() {
        return new BitType(this.storage);
    }

    public BitTypeDisplay getDefaultDisplay(Image<BitType> image) {
        return new BitTypeDisplay(image);
    }

    @Override
    public boolean get() {
        return this.b.getValue(this.i);
    }

    @Override
    public void set(boolean bl) {
        this.b.setValue(this.i, bl);
    }

    @Override
    public int getInteger() {
        return this.get() ? 1 : 0;
    }

    @Override
    public long getIntegerLong() {
        return this.get() ? 1L : 0L;
    }

    @Override
    public void setInteger(int n) {
        if (n >= 1) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public void setInteger(long l) {
        if (l >= 1L) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void set(BitType bitType) {
        this.b.setValue(this.i, bitType.get());
    }

    @Override
    public void and(BitType bitType) {
        this.b.setValue(this.i, this.b.getValue(this.i) && bitType.get());
    }

    @Override
    public void or(BitType bitType) {
        this.b.setValue(this.i, this.b.getValue(this.i) || bitType.get());
    }

    @Override
    public void xor(BitType bitType) {
        this.b.setValue(this.i, this.b.getValue(this.i) ^ bitType.get());
    }

    @Override
    public void not() {
        this.b.setValue(this.i, !this.b.getValue(this.i));
    }

    @Override
    public void add(BitType bitType) {
        this.xor(bitType);
    }

    @Override
    public void div(BitType bitType) {
        this.and(bitType);
    }

    @Override
    public void mul(BitType bitType) {
        this.and(bitType);
    }

    @Override
    public void sub(BitType bitType) {
        this.xor(bitType);
    }

    @Override
    public void mul(float f) {
        if (f >= 0.5f) {
            this.b.setValue(this.i, this.b.getValue(this.i));
        } else {
            if (this.b.getValue(this.i)) {
                // empty if block
            }
            this.b.setValue(this.i, false);
        }
    }

    @Override
    public void mul(double d) {
        if (d >= 0.5) {
            this.b.setValue(this.i, this.b.getValue(this.i));
        } else {
            if (this.b.getValue(this.i)) {
                // empty if block
            }
            this.b.setValue(this.i, false);
        }
    }

    @Override
    public void setOne() {
        this.b.setValue(this.i, true);
    }

    @Override
    public void setZero() {
        this.b.setValue(this.i, false);
    }

    @Override
    public void inc() {
        this.b.setValue(this.i, !this.b.getValue(this.i));
    }

    @Override
    public void dec() {
        this.inc();
    }

    @Override
    public int compareTo(BitType bitType) {
        boolean bl = this.b.getValue(this.i);
        boolean bl2 = bitType.get();
        if (bl && !bl2) {
            return 1;
        }
        if (!bl && bl2) {
            return -1;
        }
        return 0;
    }

    public BitType[] createArray1D(int n) {
        return new BitType[n];
    }

    public BitType[][] createArray2D(int n, int n2) {
        return new BitType[n][n2];
    }

    public BitType[][][] createArray3D(int n, int n2, int n3) {
        return new BitType[n][n2][n3];
    }

    @Override
    public BitType createVariable() {
        return new BitType();
    }

    @Override
    public BitType copy() {
        return new BitType(this.b.getValue(this.i));
    }

    @Override
    public String toString() {
        boolean bl = this.b.getValue(this.i);
        if (bl) {
            return "1";
        }
        return "0";
    }
}

