/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.label;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.BasePairTypeDisplay;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.BasePairType;
import mpicbg.imglib.type.TypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePairBitType
extends TypeImpl<BasePairBitType>
implements BasePairType<BasePairBitType> {
    final DirectAccessContainer<BasePairBitType, ? extends BitAccess> storage;
    BitAccess b;
    int j1;
    int j2;
    int j3;

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    public BasePairBitType(DirectAccessContainer<BasePairBitType, ? extends BitAccess> directAccessContainer) {
        this.storage = directAccessContainer;
        this.updateIndex(0);
    }

    public BasePairBitType(Base base) {
        this.storage = null;
        this.updateIndex(0);
        this.b = new BitArray(3);
        this.set(base);
    }

    public BasePairBitType() {
        this(Base.N);
    }

    @Override
    public DirectAccessContainer<BasePairBitType, ? extends BitAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<BasePairBitType, BitAccess> directAccessContainer = directAccessContainerFactory.createBitInstance(nArray, 3);
        BasePairBitType basePairBitType = new BasePairBitType(directAccessContainer);
        directAccessContainer.setLinkedType(basePairBitType);
        return directAccessContainer;
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.b = this.storage.update(cursor);
    }

    @Override
    public BasePairBitType duplicateTypeOnSameDirectAccessContainer() {
        return new BasePairBitType(this.storage);
    }

    @Override
    public void updateIndex(int n) {
        this.i = n;
        this.j1 = n * 3;
        this.j2 = this.j1 + 1;
        this.j3 = this.j1 + 2;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.j1 += 3;
        this.j2 += 3;
        this.j3 += 3;
    }

    @Override
    public void incIndex(int n) {
        this.i += n;
        int n2 = 3 * n;
        this.j1 += n2;
        this.j2 += n2;
        this.j3 += n2;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.j1 -= 3;
        this.j2 -= 3;
        this.j3 -= 3;
    }

    @Override
    public void decIndex(int n) {
        this.i -= n;
        int n2 = 3 * n;
        this.j1 -= n2;
        this.j2 -= n2;
        this.j3 -= n2;
    }

    @Override
    public Display<BasePairBitType> getDefaultDisplay(Image<BasePairBitType> image) {
        return new BasePairTypeDisplay<BasePairBitType>(image);
    }

    @Override
    public void set(Base base) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        switch (base) {
            case A: {
                bl3 = false;
                bl2 = false;
                bl = false;
                break;
            }
            case T: {
                bl2 = false;
                bl = false;
                bl3 = true;
                break;
            }
            case G: {
                bl2 = true;
                bl = true;
                bl3 = false;
                break;
            }
            case C: {
                bl = false;
                bl3 = true;
                bl2 = true;
                break;
            }
            case gap: {
                bl = true;
                bl3 = false;
                bl2 = false;
                break;
            }
            default: {
                bl = true;
                bl2 = false;
                bl3 = true;
            }
        }
        this.b.setValue(this.j1, bl);
        this.b.setValue(this.j2, bl2);
        this.b.setValue(this.j3, bl3);
    }

    @Override
    public Base get() {
        boolean bl = this.b.getValue(this.j1);
        boolean bl2 = this.b.getValue(this.j2);
        boolean bl3 = this.b.getValue(this.j3);
        Base base = !bl ? (!bl2 ? (!bl3 ? Base.A : Base.T) : (!bl3 ? Base.G : Base.C)) : (!bl3 ? Base.gap : Base.N);
        return base;
    }

    @Override
    public int compareTo(BasePairBitType basePairBitType) {
        Base base;
        Base base2 = this.get();
        if (base2 == (base = basePairBitType.get())) {
            return 0;
        }
        switch (base2) {
            case gap: {
                return -1;
            }
            case N: {
                if (base == Base.gap) {
                    return 1;
                }
                return -1;
            }
            case A: {
                if (base == Base.gap || base == Base.N) {
                    return 1;
                }
                return -1;
            }
            case T: {
                if (base == Base.G || base == Base.C) {
                    return -1;
                }
                return 1;
            }
            case G: {
                if (base == Base.C) {
                    return -1;
                }
                return 1;
            }
        }
        return 1;
    }

    @Override
    public void complement() {
        Base base = this.get();
        switch (base) {
            case A: {
                this.set(Base.T);
                break;
            }
            case T: {
                this.set(Base.A);
                break;
            }
            case G: {
                this.set(Base.C);
                break;
            }
            case C: {
                this.set(Base.G);
            }
        }
    }

    @Override
    public byte baseToValue() {
        Base base = this.get();
        switch (base) {
            case N: {
                return 1;
            }
            case A: {
                return 2;
            }
            case T: {
                return 3;
            }
            case G: {
                return 4;
            }
            case C: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public void set(BasePairBitType basePairBitType) {
        this.set(basePairBitType.get());
    }

    public BasePairBitType[] createArray1D(int n) {
        return new BasePairBitType[n];
    }

    public BasePairBitType[][] createArray2D(int n, int n2) {
        return new BasePairBitType[n][n2];
    }

    public BasePairBitType[][][] createArray3D(int n, int n2, int n3) {
        return new BasePairBitType[n][n2][n3];
    }

    @Override
    public BasePairBitType createVariable() {
        return new BasePairBitType();
    }

    @Override
    public BasePairBitType copy() {
        return new BasePairBitType(this.get());
    }

    @Override
    public String toString() {
        return this.get().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Base {
        gap,
        N,
        A,
        T,
        G,
        C;

    }
}

