/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type;

import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.integer.ByteType;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.type.numeric.real.FloatType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeConverter {
    public abstract void convert();

    public static <A extends Type<A>, B extends Type<B>> TypeConverter getTypeConverter(A a, B b) {
        if (a instanceof ByteType) {
            return TypeConverter.getTypeConverter((ByteType)a, b);
        }
        if (a instanceof ShortType) {
            return TypeConverter.getTypeConverter((ShortType)a, b);
        }
        System.out.println("mpi.imglib.type.TypeConverter(): Do not know how to convert Type " + a.getClass());
        return null;
    }

    public static <A extends Type<A>> TypeConverter getTypeConverter(final ByteType byteType, A a) {
        if (ByteType.class.isInstance(a)) {
            final ByteType byteType2 = (ByteType)a;
            return new TypeConverter(){

                public final void convert() {
                    byteType2.set(byteType);
                }
            };
        }
        if (ShortType.class.isInstance(a)) {
            final ShortType shortType = (ShortType)a;
            return new TypeConverter(){

                public final void convert() {
                    shortType.set((short)(byteType.get() & 0xFF));
                }
            };
        }
        if (IntType.class.isInstance(a)) {
            final IntType intType = (IntType)a;
            return new TypeConverter(){

                public final void convert() {
                    intType.set(byteType.get() & 0xFF);
                }
            };
        }
        if (LongType.class.isInstance(a)) {
            final IntType intType = (IntType)a;
            return new TypeConverter(){

                public final void convert() {
                    intType.set(byteType.get() & 0xFF);
                }
            };
        }
        if (FloatType.class.isInstance(a)) {
            final FloatType floatType = (FloatType)a;
            return new TypeConverter(){

                public final void convert() {
                    floatType.set(byteType.get() & 0xFF);
                }
            };
        }
        System.out.println("mpi.imglib.type.TypeConverter(): Do not know how to convert Type ByteType to Type " + a.getClass());
        return null;
    }

    public static <A extends Type<A>> TypeConverter getTypeConverter(final ShortType shortType, A a) {
        if (ShortType.class.isInstance(a)) {
            final ShortType shortType2 = (ShortType)a;
            return new TypeConverter(){

                public final void convert() {
                    shortType2.set(shortType);
                }
            };
        }
        if (FloatType.class.isInstance(a)) {
            final FloatType floatType = (FloatType)a;
            return new TypeConverter(){

                public final void convert() {
                    floatType.set(shortType.get() & 0xFF);
                }
            };
        }
        System.out.println("mpi.imglib.type.TypeConverter(): Do not know how to convert Type ShortType to Type " + a.getClass());
        return null;
    }
}

