/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.outofbounds;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfBoundsStrategyPeriodic<T extends Type<T>>
extends OutOfBoundsStrategy<T> {
    final LocalizableCursor<T> parentCursor;
    final LocalizableByDimCursor<T> circleCursor;
    final T type;
    final T circleType;
    final int numDimensions;
    final int[] dimension;
    final int[] position;
    final int[] circledPosition;

    public OutOfBoundsStrategyPeriodic(LocalizableCursor<T> localizableCursor) {
        super(localizableCursor);
        this.parentCursor = localizableCursor;
        this.circleCursor = localizableCursor.getImage().createLocalizableByDimCursor();
        this.circleType = this.circleCursor.getType();
        this.type = this.circleType.createVariable();
        this.numDimensions = localizableCursor.getImage().getNumDimensions();
        this.dimension = localizableCursor.getImage().getDimensions();
        this.position = new int[this.numDimensions];
        this.circledPosition = new int[this.numDimensions];
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public final void notifyOutOfBOunds() {
        this.parentCursor.getPosition(this.position);
        OutOfBoundsStrategyPeriodic.getCircleCoordinate(this.position, this.circledPosition, this.dimension, this.numDimensions);
        this.circleCursor.setPosition(this.circledPosition);
        this.type.set(this.circleType);
    }

    @Override
    public void notifyOutOfBOunds(int n, int n2) {
        int n3 = this.circleCursor.getPosition(n2);
        this.circleCursor.move(OutOfBoundsStrategyPeriodic.getCircleCoordinateDim(n3 + n, this.dimension[n2]) - n3, n2);
        this.type.set(this.circleType);
    }

    @Override
    public void notifyOutOfBOundsFwd(int n) {
        int n2 = this.circleCursor.getPosition(n);
        this.circleCursor.move(OutOfBoundsStrategyPeriodic.getCircleCoordinateDim(n2 + 1, this.dimension[n]) - n2, n);
        this.type.set(this.circleType);
    }

    @Override
    public void notifyOutOfBOundsBck(int n) {
        int n2 = this.circleCursor.getPosition(n);
        this.circleCursor.move(OutOfBoundsStrategyPeriodic.getCircleCoordinateDim(n2 - 1, this.dimension[n]) - n2, n);
        this.type.set(this.circleType);
    }

    @Override
    public void initOutOfBOunds() {
        this.parentCursor.getPosition(this.position);
        OutOfBoundsStrategyPeriodic.getCircleCoordinate(this.position, this.circledPosition, this.dimension, this.numDimensions);
        this.circleCursor.setPosition(this.circledPosition);
        this.type.set(this.circleType);
    }

    private static final int getCircleCoordinateDim(int n, int n2) {
        if (n > -1) {
            return n % n2;
        }
        return n2 - 1 + (n + 1) % n2;
    }

    private static final void getCircleCoordinate(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        for (int i = 0; i < n; ++i) {
            nArray2[i] = OutOfBoundsStrategyPeriodic.getCircleCoordinateDim(nArray[i], nArray3[i]);
        }
    }

    @Override
    public void close() {
        this.circleCursor.close();
    }
}

