/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.outofbounds;

import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorExpWindowing;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfBoundsStrategyMirrorExpWindowingFactory<T extends RealType<T>>
extends OutOfBoundsStrategyFactory<T> {
    int[] fadeOutDistance = null;
    int minFadeOutDistance = 6;
    int commonFadeOutDistance = 6;
    float commonRelativeDistanceFadeOut = Float.NaN;
    float exponent = 10.0f;

    public OutOfBoundsStrategyMirrorExpWindowingFactory() {
    }

    public OutOfBoundsStrategyMirrorExpWindowingFactory(float f) {
        this.commonRelativeDistanceFadeOut = f;
    }

    public OutOfBoundsStrategyMirrorExpWindowingFactory(int n) {
        this.commonFadeOutDistance = n;
    }

    public OutOfBoundsStrategyMirrorExpWindowingFactory(int[] nArray) {
        this.fadeOutDistance = (int[])nArray.clone();
    }

    public void setExponent(float f) {
        this.exponent = f;
    }

    public float getExponent() {
        return this.exponent;
    }

    public void setMinFadeOutDistance(int n) {
        this.minFadeOutDistance = n;
    }

    public int getMinFadeOutDistance() {
        return this.minFadeOutDistance;
    }

    public void setCommonFadeOutDistance(int n) {
        this.commonFadeOutDistance = n;
    }

    public int getCommonFadeOutDistance() {
        return this.commonFadeOutDistance;
    }

    public void setCommonRelativeFadeOutDistance(float f) {
        this.commonRelativeDistanceFadeOut = f;
    }

    public float getCommonRelativeFadeOutDistance() {
        return this.commonRelativeDistanceFadeOut;
    }

    public void setFadeOutDistance(int[] nArray) {
        this.fadeOutDistance = (int[])nArray.clone();
    }

    public int[] getFadeOutDistance() {
        return (int[])this.fadeOutDistance.clone();
    }

    @Override
    public OutOfBoundsStrategyMirrorExpWindowing<T> createStrategy(LocalizableCursor<T> localizableCursor) {
        if (Float.isNaN(this.commonRelativeDistanceFadeOut)) {
            if (this.fadeOutDistance == null) {
                this.fadeOutDistance = new int[localizableCursor.getImage().getNumDimensions()];
                for (int i = 0; i < localizableCursor.getNumDimensions(); ++i) {
                    this.fadeOutDistance[i] = Math.max(this.minFadeOutDistance, this.commonFadeOutDistance);
                }
            } else {
                for (int i = 0; i < localizableCursor.getNumDimensions(); ++i) {
                    this.fadeOutDistance[i] = Math.max(this.minFadeOutDistance, this.fadeOutDistance[i]);
                }
            }
        } else {
            if (this.commonRelativeDistanceFadeOut <= 0.0f) {
                this.commonRelativeDistanceFadeOut = 0.1f;
            }
            this.fadeOutDistance = new int[localizableCursor.getNumDimensions()];
            for (int i = 0; i < localizableCursor.getNumDimensions(); ++i) {
                this.fadeOutDistance[i] = Math.max(this.minFadeOutDistance, Util.round((float)localizableCursor.getImage().getDimension(i) * this.commonRelativeDistanceFadeOut) / 2);
            }
        }
        return new OutOfBoundsStrategyMirrorExpWindowing<T>(localizableCursor, this.fadeOutDistance, this.exponent);
    }
}

