/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.outofbounds;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfBoundsStrategyMirrorExpWindowing<T extends RealType<T>>
extends OutOfBoundsStrategy<T> {
    final LocalizableCursor<T> parentCursor;
    final LocalizableByDimCursor<T> mirrorCursor;
    final T type;
    final T mirrorType;
    final int numDimensions;
    final int[] dimension;
    final int[] position;
    final int[] mirroredPosition;
    final int[] currentDirection;
    final int[] tmp;
    final float[][] weights;
    final float cutOff = 1.0E-4f;

    public OutOfBoundsStrategyMirrorExpWindowing(LocalizableCursor<T> localizableCursor, int[] nArray, float f) {
        super(localizableCursor);
        int n;
        this.parentCursor = localizableCursor;
        this.mirrorCursor = localizableCursor.getImage().createLocalizableByDimCursor();
        this.mirrorType = (RealType)this.mirrorCursor.getType();
        this.type = (RealType)this.mirrorType.createVariable();
        this.numDimensions = localizableCursor.getImage().getNumDimensions();
        this.dimension = localizableCursor.getImage().getDimensions();
        this.position = new int[this.numDimensions];
        this.mirroredPosition = new int[this.numDimensions];
        this.currentDirection = new int[this.numDimensions];
        this.tmp = new int[this.numDimensions];
        this.weights = new float[this.numDimensions][];
        for (n = 0; n < this.numDimensions; ++n) {
            this.weights[n] = new float[Math.max(1, nArray[n])];
        }
        for (n = 0; n < this.numDimensions; ++n) {
            int n2 = this.weights[n].length;
            if (n2 > 1) {
                for (int i = 0; i < n2; ++i) {
                    float f2 = (float)i / (float)(n2 - 1);
                    this.weights[n][i] = Util.isApproxEqual(f, 1.0f, 1.0E-4f) ? 1.0f - f2 : (float)(1.0 - 1.0 / Math.pow(f, 1.0f - f2)) * (1.0f + 1.0f / (f - 1.0f));
                }
                continue;
            }
            this.weights[n][0] = 0.0f;
        }
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public final void notifyOutOfBOunds() {
        int n;
        this.parentCursor.getPosition(this.position);
        this.getMirrorCoordinate(this.position, this.mirroredPosition);
        this.mirrorCursor.setPosition(this.mirroredPosition);
        this.type.set(this.mirrorType);
        this.type.mul(this.getWeight(this.position));
        for (n = 0; n < this.numDimensions; ++n) {
            this.tmp[n] = this.position[n] + 1;
        }
        this.getMirrorCoordinate(this.tmp, this.currentDirection);
        for (n = 0; n < this.numDimensions; ++n) {
            this.currentDirection[n] = this.currentDirection[n] - this.mirroredPosition[n];
        }
    }

    protected final float getWeight(int[] nArray) {
        float f = 1.0f;
        for (int i = 0; i < this.numDimensions; ++i) {
            int n;
            int n2 = nArray[i];
            if (n2 < 0) {
                n = -n2 - 1;
            } else {
                if (n2 < this.dimension[i]) continue;
                n = n2 - this.dimension[i];
            }
            if (n < this.weights[i].length) {
                f *= this.weights[i][n];
                continue;
            }
            return 0.0f;
        }
        return f;
    }

    @Override
    public void notifyOutOfBOunds(int n, int n2) {
        if (Math.abs(n) > 10) {
            this.notifyOutOfBOunds();
        } else if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.notifyOutOfBOundsFwd(n2);
            }
        } else {
            for (int i = 0; i < -n; ++i) {
                this.notifyOutOfBOundsBck(n2);
            }
        }
    }

    @Override
    public void notifyOutOfBOundsFwd(int n) {
        if (this.currentDirection[n] == 1) {
            if (this.mirrorCursor.getPosition(n) + 1 == this.dimension[n]) {
                this.mirrorCursor.bck(n);
                this.currentDirection[n] = -1;
            } else {
                this.mirrorCursor.fwd(n);
            }
        } else if (this.mirrorCursor.getPosition(n) == 0) {
            this.currentDirection[n] = 1;
            this.mirrorCursor.fwd(n);
        } else {
            this.mirrorCursor.bck(n);
        }
        this.type.set(this.mirrorType);
        this.parentCursor.getPosition(this.position);
        this.type.mul(this.getWeight(this.position));
    }

    @Override
    public void notifyOutOfBOundsBck(int n) {
        if (this.currentDirection[n] == 1) {
            if (this.mirrorCursor.getPosition(n) == 0) {
                this.mirrorCursor.fwd(n);
                this.currentDirection[n] = -1;
            } else {
                this.mirrorCursor.bck(n);
            }
        } else if (this.mirrorCursor.getPosition(n) + 1 == this.dimension[n]) {
            this.mirrorCursor.bck(n);
            this.currentDirection[n] = 1;
        } else {
            this.mirrorCursor.fwd(n);
        }
        this.type.set(this.mirrorType);
        this.parentCursor.getPosition(this.position);
        this.type.mul(this.getWeight(this.position));
    }

    @Override
    public void initOutOfBOunds() {
        this.notifyOutOfBOunds();
    }

    protected void getMirrorCoordinate(int[] nArray, int[] nArray2) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray2[i] = nArray[i];
            if (nArray2[i] >= this.dimension[i]) {
                nArray2[i] = this.dimension[i] - (nArray2[i] - this.dimension[i] + 2);
            }
            if (nArray2[i] >= 0) continue;
            int n = 0;
            int n2 = 1;
            while (nArray2[i] < 0) {
                if ((n += n2) == this.dimension[i] - 1 || n == 0) {
                    n2 *= -1;
                }
                int n3 = i;
                nArray2[n3] = nArray2[n3] + 1;
            }
            nArray2[i] = n;
        }
    }

    @Override
    public void close() {
        this.mirrorCursor.close();
    }
}

