/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.outofbounds;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfBoundsStrategyMirror<T extends Type<T>>
extends OutOfBoundsStrategy<T> {
    final LocalizableCursor<T> parentCursor;
    final LocalizableByDimCursor<T> mirrorCursor;
    final T type;
    final T mirrorType;
    final int numDimensions;
    final int[] dimension;
    final int[] position;
    final int[] mirroredPosition;
    final int[] currentDirection;
    final int[] tmp;

    public OutOfBoundsStrategyMirror(LocalizableCursor<T> localizableCursor) {
        super(localizableCursor);
        this.parentCursor = localizableCursor;
        this.mirrorCursor = localizableCursor.getImage().createLocalizableByDimCursor();
        this.mirrorType = this.mirrorCursor.getType();
        this.type = this.mirrorType.createVariable();
        this.numDimensions = localizableCursor.getImage().getNumDimensions();
        this.dimension = localizableCursor.getImage().getDimensions();
        this.position = new int[this.numDimensions];
        this.mirroredPosition = new int[this.numDimensions];
        this.currentDirection = new int[this.numDimensions];
        this.tmp = new int[this.numDimensions];
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public final void notifyOutOfBOunds() {
        int n;
        this.parentCursor.getPosition(this.position);
        this.getMirrorCoordinate(this.position, this.mirroredPosition);
        this.mirrorCursor.setPosition(this.mirroredPosition);
        this.type.set(this.mirrorType);
        for (n = 0; n < this.numDimensions; ++n) {
            this.tmp[n] = this.position[n] + 1;
        }
        this.getMirrorCoordinate(this.tmp, this.currentDirection);
        for (n = 0; n < this.numDimensions; ++n) {
            this.currentDirection[n] = this.currentDirection[n] - this.mirroredPosition[n];
        }
    }

    @Override
    public void notifyOutOfBOunds(int n, int n2) {
        if (Math.abs(n) > 10) {
            this.notifyOutOfBOunds();
        } else if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.notifyOutOfBOundsFwd(n2);
            }
        } else {
            for (int i = 0; i < -n; ++i) {
                this.notifyOutOfBOundsBck(n2);
            }
        }
    }

    @Override
    public void notifyOutOfBOundsFwd(int n) {
        if (this.currentDirection[n] == 1) {
            if (this.mirrorCursor.getPosition(n) + 1 == this.dimension[n]) {
                this.mirrorCursor.bck(n);
                this.currentDirection[n] = -1;
            } else {
                this.mirrorCursor.fwd(n);
            }
        } else if (this.mirrorCursor.getPosition(n) == 0) {
            this.currentDirection[n] = 1;
            this.mirrorCursor.fwd(n);
        } else {
            this.mirrorCursor.bck(n);
        }
        this.type.set(this.mirrorType);
    }

    @Override
    public void notifyOutOfBOundsBck(int n) {
        if (this.currentDirection[n] == 1) {
            if (this.mirrorCursor.getPosition(n) == 0) {
                this.mirrorCursor.fwd(n);
                this.currentDirection[n] = -1;
            } else {
                this.mirrorCursor.bck(n);
            }
        } else if (this.mirrorCursor.getPosition(n) + 1 == this.dimension[n]) {
            this.mirrorCursor.bck(n);
            this.currentDirection[n] = 1;
        } else {
            this.mirrorCursor.fwd(n);
        }
        this.type.set(this.mirrorType);
    }

    @Override
    public void initOutOfBOunds() {
        this.notifyOutOfBOunds();
    }

    protected void getMirrorCoordinate(int[] nArray, int[] nArray2) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray2[i] = nArray[i];
            if (nArray2[i] >= this.dimension[i]) {
                nArray2[i] = this.dimension[i] - (nArray2[i] - this.dimension[i] + 2);
            }
            if (nArray2[i] >= 0) continue;
            int n = 0;
            int n2 = 1;
            while (nArray2[i] < 0) {
                if ((n += n2) == this.dimension[i] - 1 || n == 0) {
                    n2 *= -1;
                }
                int n3 = i;
                nArray2[n3] = nArray2[n3] + 1;
            }
            nArray2[i] = n;
        }
    }

    @Override
    public void close() {
        this.mirrorCursor.close();
    }
}

