/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.multithreading;

import java.util.Vector;
import mpicbg.imglib.multithreading.Chunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMultiThreading {
    public static Vector<Chunk> divideIntoChunks(long l, int n) {
        long l2 = l / (long)n;
        long l3 = l % (long)n;
        Vector<Chunk> vector = new Vector<Chunk>();
        for (int i = 0; i < n; ++i) {
            long l4 = (long)i * l2;
            long l5 = i == n - 1 ? l2 + l3 : l2;
            vector.add(new Chunk(l4, l5));
        }
        return vector;
    }

    public static void startTask(Runnable runnable) {
        Thread[] threadArray = SimpleMultiThreading.newThreads();
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(runnable);
        }
        SimpleMultiThreading.startAndJoin(threadArray);
    }

    public static void startTask(Runnable runnable, int n) {
        Thread[] threadArray = SimpleMultiThreading.newThreads(n);
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(runnable);
        }
        SimpleMultiThreading.startAndJoin(threadArray);
    }

    public static Thread[] newThreads() {
        int n = Runtime.getRuntime().availableProcessors();
        return new Thread[n];
    }

    public static Thread[] newThreads(int n) {
        return new Thread[n];
    }

    public static void startAndJoin(Thread[] threadArray) {
        int n;
        for (n = 0; n < threadArray.length; ++n) {
            threadArray[n].setPriority(5);
            threadArray[n].start();
        }
        try {
            for (n = 0; n < threadArray.length; ++n) {
                threadArray[n].join();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public static void start(Thread[] threadArray) {
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i].setPriority(1);
            threadArray[i].start();
        }
    }

    public static void threadHaltUnClean() {
        boolean bl = false;
        while (!bl) {
        }
    }

    public static void threadWait(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("MultiThreading.threadWait(): Thread woken up: " + interruptedException);
        }
    }
}

