/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.labeling;

import java.util.Arrays;
import java.util.Iterator;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.type.label.FakeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizableLabelingCursor<T extends Comparable<T>>
implements LocalizableCursor<FakeType> {
    protected final LocalizableCursor<LabelingType<T>> c;
    protected final FakeType fakeType = new FakeType();
    int[] offset;
    protected int[] currentPosition;
    protected int arrayIndex;
    protected int storageIndex;
    protected T label;
    protected boolean advanced;
    protected boolean has_next;

    public LocalizableLabelingCursor(LocalizableCursor<LabelingType<T>> localizableCursor, T t) {
        this.c = localizableCursor;
        this.label = t;
        this.offset = localizableCursor.getPosition();
        Arrays.fill(this.offset, 0);
        this.currentPosition = localizableCursor.createPositionArray();
        Arrays.fill(this.currentPosition, Integer.MIN_VALUE);
        this.advanced = false;
    }

    public LocalizableLabelingCursor(RegionOfInterestCursor<LabelingType<T>> regionOfInterestCursor, int[] nArray, T t) {
        this(regionOfInterestCursor, t);
        this.offset = nArray;
    }

    protected boolean isLabeled() {
        LabelingType labelingType = (LabelingType)this.c.getType();
        for (Comparable comparable : labelingType.getLabeling()) {
            if (!comparable.equals(this.label)) continue;
            return true;
        }
        return false;
    }

    protected void getCursorPosition(int[] nArray) {
        this.c.getPosition(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            nArray[n] = nArray[n] + this.offset[i];
        }
    }

    protected void advance() {
        if (this.advanced) {
            return;
        }
        this.arrayIndex = this.c.getArrayIndex();
        this.storageIndex = this.c.getStorageIndex();
        this.getCursorPosition(this.currentPosition);
        while (this.c.hasNext()) {
            this.c.next();
            if (!this.isLabeled()) continue;
            this.advanced = true;
            this.has_next = true;
            return;
        }
        this.has_next = false;
        this.advanced = true;
    }

    @Override
    public void reset() {
        this.c.reset();
        this.advanced = false;
    }

    @Override
    public boolean isActive() {
        return this.c.isActive();
    }

    @Override
    public Image<FakeType> getImage() {
        return null;
    }

    @Override
    public FakeType getType() {
        return this.fakeType;
    }

    @Override
    public int getArrayIndex() {
        this.advance();
        return this.arrayIndex;
    }

    @Override
    public int getStorageIndex() {
        this.advance();
        return this.storageIndex;
    }

    @Override
    public Container<FakeType> getStorageContainer() {
        return null;
    }

    @Override
    public void setDebug(boolean bl) {
        this.c.setDebug(bl);
    }

    @Override
    public int[] createPositionArray() {
        return this.c.createPositionArray();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.has_next;
    }

    @Override
    public FakeType next() {
        this.fwd();
        return this.fakeType;
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<FakeType> iterator() {
        this.reset();
        return this;
    }

    @Override
    public void fwd(long l) {
        for (long i = 0L; i < l && this.hasNext(); ++i) {
            this.fwd();
        }
    }

    @Override
    public void fwd() {
        this.advanced = false;
    }

    @Override
    public int getNumDimensions() {
        return this.c.getNumDimensions();
    }

    @Override
    public int[] getDimensions() {
        return this.c.getDimensions();
    }

    @Override
    public void getDimensions(int[] nArray) {
        this.c.getDimensions(nArray);
    }

    @Override
    public void getPosition(int[] nArray) {
        this.advance();
        System.arraycopy(this.currentPosition, 0, nArray, 0, this.currentPosition.length);
    }

    @Override
    public int[] getPosition() {
        this.advance();
        return (int[])this.currentPosition.clone();
    }

    @Override
    public int getPosition(int n) {
        this.advance();
        return this.currentPosition[n];
    }

    @Override
    public String getPositionAsString() {
        this.advance();
        StringBuilder stringBuilder = new StringBuilder(Integer.toString(this.currentPosition[0]));
        for (int i = 1; i < this.currentPosition.length; ++i) {
            stringBuilder.append(',');
            stringBuilder.append(this.currentPosition[i]);
        }
        return stringBuilder.toString();
    }
}

