/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.labeling;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.labeling.LabelingMapping;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.TypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelingType<T extends Comparable<T>>
extends TypeImpl<LabelingType<T>>
implements Type<LabelingType<T>> {
    protected final DirectAccessContainer<LabelingType<T>, ? extends IntAccess> storage;
    protected final LabelingMapping<T, Integer> mapping;
    protected List<T> value = null;
    protected IntAccess access = null;
    protected long[] generation;

    public LabelingType(DirectAccessContainer<LabelingType<T>, ? extends IntAccess> directAccessContainer) {
        this.storage = directAccessContainer;
        this.mapping = new LabelingMapping(new Integer(0));
        this.generation = new long[1];
    }

    public LabelingType(List<T> list) {
        this.value = Collections.unmodifiableList(list);
        this.storage = null;
        this.mapping = null;
    }

    public LabelingType() {
        this.storage = null;
        this.mapping = null;
        this.value = Collections.emptyList();
        this.value = Collections.unmodifiableList(this.value);
    }

    protected LabelingType(DirectAccessContainer<LabelingType<T>, ? extends IntAccess> directAccessContainer, LabelingMapping<T, Integer> labelingMapping, IntAccess intAccess, long[] lArray) {
        this.storage = directAccessContainer;
        this.mapping = labelingMapping;
        this.access = intAccess;
        this.generation = lArray;
    }

    public List<T> getLabeling() {
        if (this.value != null) {
            return this.value;
        }
        return this.mapping.listAtIndex(this.access.getValue(this.i));
    }

    public void setLabeling(List<T> list) {
        if (this.value != null) {
            this.value = list;
        } else {
            this.access.setValue(this.i, this.mapping.indexOf(list));
            this.generation[0] = this.generation[0] + 1L;
        }
    }

    public void setLabeling(T[] TArray) {
        this.setLabeling(Arrays.asList(TArray));
    }

    public void setLabel(T t) {
        ArrayList<T> arrayList = new ArrayList<T>(1);
        arrayList.add(t);
        this.setLabeling(arrayList);
    }

    public List<T> intern(List<T> list) {
        return this.mapping.intern(list);
    }

    public List<T> intern(T t) {
        ArrayList<T> arrayList = new ArrayList<T>(1);
        arrayList.add(t);
        return this.intern((T)arrayList);
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public DirectAccessContainer<LabelingType<T>, ? extends IntAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<LabelingType<LabelingType<T>>, IntAccess> directAccessContainer = directAccessContainerFactory.createIntInstance(nArray, 1);
        LabelingType<T> labelingType = new LabelingType<T>(directAccessContainer);
        directAccessContainer.setLinkedType(labelingType);
        return directAccessContainer;
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.access = this.storage.update(cursor);
    }

    @Override
    public LabelingType<T> createVariable() {
        return new LabelingType<T>();
    }

    @Override
    public LabelingType<T> copy() {
        return new LabelingType<T>(this.getLabeling());
    }

    @Override
    public LabelingType<T> duplicateTypeOnSameDirectAccessContainer() {
        return new LabelingType<T>(this.storage, this.mapping, this.access, this.generation);
    }

    @Override
    public void set(LabelingType<T> labelingType) {
        this.setLabeling(labelingType.getLabeling());
    }

    public LabelingType<T>[] createArray1D(int n) {
        LabelingType[] labelingTypeArray = (LabelingType[])Array.newInstance(this.getClass(), n);
        return labelingTypeArray;
    }

    public LabelingType<T>[][] createArray2D(int n, int n2) {
        LabelingType<T>[] labelingTypeArray = this.createArray1D(n2);
        LabelingType[][] labelingTypeArray2 = (LabelingType[][])Array.newInstance(labelingTypeArray.getClass(), n);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                labelingTypeArray2[0] = labelingTypeArray;
                break;
            }
            default: {
                labelingTypeArray2[0] = labelingTypeArray;
                for (int i = 1; i < n; ++i) {
                    labelingTypeArray2[i] = this.createArray1D(n2);
                }
            }
        }
        return labelingTypeArray2;
    }

    public LabelingType<T>[][][] createArray3D(int n, int n2, int n3) {
        LabelingType<T>[][] labelingTypeArray = this.createArray2D(n2, n3);
        LabelingType[][][] labelingTypeArray2 = (LabelingType[][][])Array.newInstance(labelingTypeArray.getClass(), n);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                labelingTypeArray2[0] = labelingTypeArray;
                break;
            }
            default: {
                labelingTypeArray2[0] = labelingTypeArray;
                for (int i = 1; i < n; ++i) {
                    labelingTypeArray2[i] = this.createArray2D(n2, n3);
                }
            }
        }
        return labelingTypeArray2;
    }

    @Override
    public String toString() {
        return this.getLabeling().toString();
    }

    @Override
    public Display<LabelingType<T>> getDefaultDisplay(Image<LabelingType<T>> image) {
        return new DefaultDisplay(image);
    }

    List<T> getLabels() {
        return this.mapping.getLabels();
    }

    long getGeneration() {
        return this.generation[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultDisplay
    extends Display<LabelingType<T>> {
        public DefaultDisplay(Image<LabelingType<T>> image) {
            super(image);
            this.min = 0.0;
            this.max = 0.0;
        }

        @Override
        public void setMinMax() {
            Cursor cursor = this.img.createCursor();
            if (!cursor.hasNext()) {
                this.min = 0.0;
                this.max = 0.0;
                return;
            }
            cursor.fwd();
            this.min = this.max = (double)this.valueAt(cursor);
            while (cursor.hasNext()) {
                cursor.fwd();
                long l = this.valueAt(cursor);
                if ((double)l > this.max) {
                    this.max = l;
                    continue;
                }
                if (!((double)l < this.min)) continue;
                this.min = l;
            }
            cursor.close();
        }

        private long valueAt(Cursor<LabelingType<T>> cursor) {
            return cursor.getType().mapping.indexOf(cursor.getType().getLabeling()).intValue();
        }

        private long valueAt(LabelingType<T> labelingType) {
            return labelingType.mapping.indexOf(labelingType.getLabeling()).intValue();
        }

        @Override
        public float get32Bit(LabelingType<T> labelingType) {
            return this.valueAt(labelingType);
        }

        @Override
        public float get32BitNormed(LabelingType<T> labelingType) {
            return this.normFloat(this.valueAt(labelingType));
        }

        @Override
        public byte get8BitSigned(LabelingType<T> labelingType) {
            return (byte)Math.round(this.normFloat(this.valueAt(labelingType)) * 255.0f);
        }

        @Override
        public short get8BitUnsigned(LabelingType<T> labelingType) {
            return (short)Math.round(this.normFloat(this.valueAt(labelingType)) * 255.0f);
        }
    }
}

