/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.labeling;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LabelingMapping<T extends Comparable<T>, N extends Number> {
    Constructor<N> constructor;
    N instance;
    protected Map<List<T>, InternedList<T, N>> internedLists = new HashMap<List<T>, InternedList<T, N>>();
    protected ArrayList<InternedList<T, N>> listsByIndex = new ArrayList();

    public LabelingMapping(N n) {
        this.instance = n;
        Class<?> clazz = n.getClass();
        try {
            this.constructor = clazz.getConstructor(String.class);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new AssertionError((Object)securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new AssertionError((Object)"Number class cannot be constructed from a string");
        }
        List list = Collections.emptyList();
        this.intern(list);
    }

    public List<T> intern(List<T> list) {
        return this.internImpl(list);
    }

    private InternedList<T, N> internImpl(List<T> list) {
        InternedList<T, Object> internedList;
        if (list instanceof InternedList) {
            internedList = (InternedList<T, N>)list;
            if (internedList.owner == this) {
                return internedList;
            }
        }
        ArrayList<T> arrayList = new ArrayList<T>(list);
        Collections.sort(arrayList);
        internedList = this.internedLists.get(arrayList);
        if (internedList == null) {
            Number number;
            int n = this.listsByIndex.size();
            try {
                number = (Number)this.constructor.newInstance(Integer.toString(n));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw new AssertionError((Object)illegalArgumentException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                throw new AssertionError((Object)instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                if (invocationTargetException.getTargetException() instanceof NumberFormatException) {
                    throw new AssertionError((Object)String.format("Too many labels (or types of multiply-labeled pixels): %d maximum", n));
                }
                throw new AssertionError((Object)invocationTargetException.getMessage());
            }
            internedList = new InternedList<T, Number>(list, number, this);
            this.listsByIndex.add(internedList);
            this.internedLists.put(internedList, internedList);
        }
        return internedList;
    }

    public List<T> intern(T[] TArray) {
        return this.intern(Arrays.asList(TArray));
    }

    public N indexOf(List<T> list) {
        InternedList<T, N> internedList = this.internImpl(list);
        return internedList.index;
    }

    public N indexOf(T[] TArray) {
        return this.indexOf(this.intern((Comparable[])TArray));
    }

    public List<T> listAtIndex(int n) {
        return this.listsByIndex.get(n);
    }

    public List<T> getLabels() {
        HashSet<Comparable> hashSet = new HashSet<Comparable>();
        for (InternedList<T, N> internedList : this.listsByIndex) {
            for (Comparable comparable : internedList) {
                hashSet.add(comparable);
            }
        }
        return new ArrayList(hashSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternedList<T1 extends Comparable<T1>, N extends Number>
    implements List<T1> {
        private final List<T1> value;
        final N index;
        final LabelingMapping<T1, N> owner;

        public InternedList(List<T1> list, N n, LabelingMapping<T1, N> labelingMapping) {
            this.value = Collections.unmodifiableList(list);
            this.index = n;
            this.owner = labelingMapping;
        }

        @Override
        public int size() {
            return this.value.size();
        }

        @Override
        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.value.contains(object);
        }

        @Override
        public Iterator<T1> iterator() {
            return this.value.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.value.toArray();
        }

        @Override
        public boolean add(T1 T1) {
            return this.value.add(T1);
        }

        @Override
        public boolean remove(Object object) {
            return this.value.remove(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.value.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends T1> collection) {
            return this.value.addAll(collection);
        }

        @Override
        public boolean addAll(int n, Collection<? extends T1> collection) {
            return this.value.addAll(n, collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.value.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.value.retainAll(collection);
        }

        @Override
        public void clear() {
            this.value.clear();
        }

        @Override
        public T1 get(int n) {
            return (T1)((Comparable)this.value.get(n));
        }

        @Override
        public T1 set(int n, T1 T1) {
            return (T1)((Comparable)this.value.set(n, T1));
        }

        @Override
        public void add(int n, T1 T1) {
            this.value.add(n, T1);
        }

        @Override
        public T1 remove(int n) {
            return (T1)((Comparable)this.value.remove(n));
        }

        @Override
        public int indexOf(Object object) {
            return this.value.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.value.lastIndexOf(object);
        }

        @Override
        public ListIterator<T1> listIterator() {
            return this.value.listIterator();
        }

        @Override
        public ListIterator<T1> listIterator(int n) {
            return this.value.listIterator(n);
        }

        @Override
        public List<T1> subList(int n, int n2) {
            return this.value.subList(n, n2);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.value.toArray(TArray);
        }

        @Override
        public int hashCode() {
            return ((Object)this.value).hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof InternedList) {
                InternedList internedList = (InternedList)object;
                return ((Object)this.value).equals(internedList.value);
            }
            return ((Object)this.value).equals(object);
        }
    }
}

