/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.labeling;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.labeling.BoundingBox;
import mpicbg.imglib.labeling.Labeling;
import mpicbg.imglib.labeling.LabelingCursorStrategy;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.labeling.LocalizableLabelingCursor;
import mpicbg.imglib.labeling.LocalizableLabelingPerimeterCursor;
import mpicbg.imglib.type.label.FakeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLabelingCursorStrategy<T extends Comparable<T>, L extends Labeling<T>>
implements LabelingCursorStrategy<T, L> {
    protected final L labeling;
    protected long generation;
    protected LabelingType<T> type = null;
    protected Map<T, LabelStatistics> statistics;

    public DefaultLabelingCursorStrategy(L l) {
        this.labeling = l;
        this.generation = Long.MIN_VALUE;
    }

    protected void computeStatistics() {
        if (this.type == null || this.type.getGeneration() != this.generation) {
            this.statistics = new HashMap<T, LabelStatistics>();
            LocalizableCursor localizableCursor = ((Image)this.labeling).createLocalizableCursor();
            if (this.type == null) {
                this.type = (LabelingType)localizableCursor.getType();
            }
            int[] nArray = localizableCursor.createPositionArray();
            LabelStatistics labelStatistics = null;
            Comparable comparable = null;
            for (LabelingType labelingType : localizableCursor) {
                localizableCursor.getPosition(nArray);
                for (Comparable comparable2 : labelingType.getLabeling()) {
                    if (labelStatistics == null || !comparable2.equals(comparable)) {
                        comparable = comparable2;
                        labelStatistics = this.statistics.get(comparable2);
                        if (labelStatistics == null) {
                            labelStatistics = new LabelStatistics(localizableCursor.getNumDimensions());
                            this.statistics.put(comparable2, labelStatistics);
                        }
                    }
                    labelStatistics.update(nArray);
                }
            }
            this.generation = this.type.getGeneration();
            localizableCursor.close();
        }
    }

    @Override
    public LocalizableCursor<FakeType> createLocalizableLabelCursor(T t) {
        int[] nArray = new int[((Image)this.labeling).getNumDimensions()];
        int[] nArray2 = new int[((Image)this.labeling).getNumDimensions()];
        this.getExtents(t, nArray, nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            nArray2[n] = nArray2[n] - nArray[i];
        }
        LocalizableByDimCursor localizableByDimCursor = ((Image)this.labeling).createLocalizableByDimCursor();
        RegionOfInterestCursor regionOfInterestCursor = new RegionOfInterestCursor(localizableByDimCursor, nArray, nArray2);
        return new LocalizableLabelingCursor(regionOfInterestCursor, nArray, t);
    }

    @Override
    public LocalizableCursor<FakeType> createLocalizablePerimeterCursor(T t) {
        int[] nArray = new int[((Image)this.labeling).getNumDimensions()];
        int[] nArray2 = new int[((Image)this.labeling).getNumDimensions()];
        this.getExtents(t, nArray, nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            nArray2[n] = nArray2[n] - nArray[i];
        }
        LocalizableByDimCursor localizableByDimCursor = ((Image)this.labeling).createLocalizableByDimCursor();
        RegionOfInterestCursor regionOfInterestCursor = new RegionOfInterestCursor(localizableByDimCursor, nArray, nArray2);
        LocalizableByDimCursor localizableByDimCursor2 = ((Image)this.labeling).createLocalizableByDimCursor();
        return new LocalizableLabelingPerimeterCursor(regionOfInterestCursor, nArray, localizableByDimCursor2, t);
    }

    @Override
    public boolean getExtents(T t, int[] nArray, int[] nArray2) {
        this.computeStatistics();
        LabelStatistics labelStatistics = this.statistics.get(t);
        if (labelStatistics == null) {
            if (nArray != null) {
                Arrays.fill(nArray, 0);
            }
            if (nArray2 != null) {
                Arrays.fill(nArray2, 0);
            }
            return false;
        }
        labelStatistics.getExtents(nArray, nArray2);
        return true;
    }

    @Override
    public boolean getRasterStart(T t, int[] nArray) {
        this.computeStatistics();
        LabelStatistics labelStatistics = this.statistics.get(t);
        if (labelStatistics == null) {
            Arrays.fill(nArray, 0);
            return false;
        }
        labelStatistics.getRasterStart(nArray);
        return true;
    }

    @Override
    public long getArea(T t) {
        this.computeStatistics();
        LabelStatistics labelStatistics = this.statistics.get(t);
        if (labelStatistics == null) {
            return 0L;
        }
        return labelStatistics.getArea();
    }

    @Override
    public Collection<T> getLabels() {
        this.computeStatistics();
        return this.statistics.keySet();
    }

    private class LabelStatistics
    extends BoundingBox {
        private int[] rasterStart;
        private long area;

        public LabelStatistics(int n) {
            super(n);
            this.area = 0L;
            this.rasterStart = new int[n];
            Arrays.fill(this.rasterStart, Integer.MAX_VALUE);
        }

        public void getRasterStart(int[] nArray) {
            System.arraycopy(this.rasterStart, 0, nArray, 0, this.rasterStart.length);
        }

        public long getArea() {
            return this.area;
        }

        public void update(int[] nArray) {
            super.update(nArray);
            ++this.area;
            for (int i = 0; i < this.rasterStart.length; ++i) {
                if (this.rasterStart[i] > nArray[i]) {
                    System.arraycopy(nArray, 0, this.rasterStart, 0, this.rasterStart.length);
                    return;
                }
                if (this.rasterStart[i] >= nArray[i]) continue;
                return;
            }
        }
    }
}

