/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.nearestneighbor;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.Interpolator3D;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolator;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NearestNeighborInterpolator3D<T extends Type<T>>
extends NearestNeighborInterpolator<T>
implements Interpolator3D<T> {
    float x = 0.0f;
    float y = 0.0f;
    float z = 0.0f;

    protected NearestNeighborInterpolator3D(Image<T> image, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(image, interpolatorFactory, outOfBoundsStrategyFactory);
    }

    @Override
    public Image<T> getImage() {
        return this.img;
    }

    @Override
    public void getPosition(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        fArray[2] = this.z;
    }

    @Override
    public float[] getPosition() {
        return new float[]{this.x, this.y, this.z};
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public void moveTo(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        int n = Util.round(f);
        int n2 = Util.round(f2);
        int n3 = Util.round(f3);
        this.cursor.move(n - this.cursor.getPosition(0), 0);
        this.cursor.move(n2 - this.cursor.getPosition(1), 1);
        this.cursor.move(n3 - this.cursor.getPosition(2), 2);
    }

    @Override
    public void moveTo(float[] fArray) {
        this.moveTo(fArray[0], fArray[1], fArray[2]);
    }

    @Override
    public void moveRel(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        this.cursor.move(Util.round(this.x) - this.cursor.getPosition(0), 0);
        this.cursor.move(Util.round(this.y) - this.cursor.getPosition(1), 1);
        this.cursor.move(Util.round(this.z) - this.cursor.getPosition(2), 2);
    }

    @Override
    public void moveRel(float[] fArray) {
        this.moveRel(fArray[0], fArray[1], fArray[2]);
    }

    @Override
    public void setPosition(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.cursor.setPosition(Util.round(f), 0);
        this.cursor.setPosition(Util.round(f2), 1);
        this.cursor.setPosition(Util.round(f3), 2);
    }

    @Override
    public void setPosition(float[] fArray) {
        this.setPosition(fArray[0], fArray[1], fArray[2]);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }
}

