/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.nearestneighbor;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.InterpolatorImpl;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NearestNeighborInterpolator<T extends Type<T>>
extends InterpolatorImpl<T> {
    final LocalizableByDimCursor<T> cursor;

    protected NearestNeighborInterpolator(Image<T> image, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(image, interpolatorFactory, outOfBoundsStrategyFactory);
        this.cursor = image.createLocalizableByDimCursor(outOfBoundsStrategyFactory);
        this.moveTo(this.position);
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public T getType() {
        return this.cursor.getType();
    }

    @Override
    public void moveTo(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = fArray[i];
            int n = Util.round(fArray[i]);
            this.cursor.move(n - this.cursor.getPosition(i), i);
        }
    }

    @Override
    public void moveRel(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = i;
            this.position[n] = this.position[n] + fArray[i];
            int n2 = Util.round(this.position[i]);
            this.cursor.move(n2 - this.cursor.getPosition(i), i);
        }
    }

    @Override
    public void setPosition(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = fArray[i];
            int n = Util.round(fArray[i]);
            this.cursor.setPosition(n, i);
        }
    }
}

