/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.linear;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolator;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearInterpolator3DRealType<T extends RealType<T>>
extends LinearInterpolator<T> {
    final int[] tmpLocation = new int[3];

    protected LinearInterpolator3DRealType(Image<T> image, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(image, interpolatorFactory, outOfBoundsStrategyFactory, false);
        this.moveTo(this.position);
    }

    @Override
    public T getType() {
        return (T)((RealType)this.tmp2);
    }

    @Override
    public void moveTo(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        this.position[0] = f;
        this.position[1] = f2;
        this.position[2] = f3;
        int n = f > 0.0f ? (int)f : (int)f - 1;
        int n2 = f2 > 0.0f ? (int)f2 : (int)f2 - 1;
        int n3 = f3 > 0.0f ? (int)f3 : (int)f3 - 1;
        this.tmpLocation[0] = n;
        this.tmpLocation[1] = n2;
        this.tmpLocation[2] = n3;
        this.cursor.moveTo(this.tmpLocation);
        float f4 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float f5 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(1);
        float f6 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float f7 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(2);
        float f8 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float f9 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(1);
        float f10 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float f11 = ((RealType)this.cursor.getType()).getRealFloat();
        float f12 = f - (float)n;
        float f13 = f2 - (float)n2;
        float f14 = f3 - (float)n3;
        float f15 = 1.0f - f12;
        float f16 = 1.0f - f13;
        float f17 = 1.0f - f14;
        float f18 = f15 * f16 * f17 * f4 + f12 * f16 * f17 * f5 + f12 * f13 * f17 * f6 + f15 * f13 * f17 * f7 + f15 * f16 * f14 * f11 + f12 * f16 * f14 * f10 + f12 * f13 * f14 * f9 + f15 * f13 * f14 * f8;
        ((RealType)this.tmp2).setReal(f18);
    }

    @Override
    public void setPosition(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        this.position[0] = f;
        this.position[1] = f2;
        this.position[2] = f3;
        int n = f > 0.0f ? (int)f : (int)f - 1;
        int n2 = f2 > 0.0f ? (int)f2 : (int)f2 - 1;
        int n3 = f3 > 0.0f ? (int)f3 : (int)f3 - 1;
        this.tmpLocation[0] = n;
        this.tmpLocation[1] = n2;
        this.tmpLocation[2] = n3;
        this.cursor.setPosition(this.tmpLocation);
        float f4 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float f5 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(1);
        float f6 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float f7 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(2);
        float f8 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.fwd(0);
        float f9 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(1);
        float f10 = ((RealType)this.cursor.getType()).getRealFloat();
        this.cursor.bck(0);
        float f11 = ((RealType)this.cursor.getType()).getRealFloat();
        float f12 = f - (float)n;
        float f13 = f2 - (float)n2;
        float f14 = f3 - (float)n3;
        float f15 = 1.0f - f12;
        float f16 = 1.0f - f13;
        float f17 = 1.0f - f14;
        float f18 = f15 * f16 * f17 * f4 + f12 * f16 * f17 * f5 + f12 * f13 * f17 * f6 + f15 * f13 * f17 * f7 + f15 * f16 * f14 * f11 + f12 * f16 * f14 * f10 + f12 * f13 * f14 * f9 + f15 * f13 * f14 * f8;
        ((RealType)this.tmp2).setReal(f18);
    }
}

