/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.linear;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.InterpolatorImpl;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearInterpolator<T extends NumericType<T>>
extends InterpolatorImpl<T> {
    final LocalizableByDimCursor<T> cursor;
    final T tmp1;
    final T tmp2;
    final int[] baseDim;
    final int[] location;
    final float[][] weights;
    final T[][] tree;
    final int[] halfTreeLevelSizes;
    final boolean[][] positions;

    protected LinearInterpolator(Image<T> image, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this(image, interpolatorFactory, outOfBoundsStrategyFactory, true);
    }

    protected LinearInterpolator(Image<T> image, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, boolean bl) {
        super(image, interpolatorFactory, outOfBoundsStrategyFactory);
        this.cursor = image.createLocalizableByDimCursor(outOfBoundsStrategyFactory);
        this.tmp1 = (NumericType)image.createType();
        this.tmp2 = (NumericType)image.createType();
        this.baseDim = new int[this.numDimensions];
        this.location = new int[this.numDimensions];
        this.weights = new float[this.numDimensions][2];
        if (bl) {
            this.tree = (NumericType[][])this.tmp1.createArray2D(this.numDimensions + 1, 1);
            this.halfTreeLevelSizes = new int[this.numDimensions + 1];
            for (int i = 0; i < this.tree.length; ++i) {
                this.tree[i] = (NumericType[])this.tmp1.createArray1D(Util.pow(2, i));
                for (int j = 0; j < this.tree[i].length; ++j) {
                    this.tree[i][j] = (NumericType)image.createType();
                }
                this.halfTreeLevelSizes[i] = this.tree[i].length / 2;
            }
            this.positions = new boolean[Util.pow(2, this.numDimensions)][this.numDimensions];
            Util.setCoordinateRecursive(this.numDimensions - 1, this.numDimensions, new int[this.numDimensions], this.positions);
            this.moveTo(this.position);
        } else {
            this.tree = null;
            this.positions = null;
            this.halfTreeLevelSizes = null;
        }
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public T getType() {
        return this.tree[0][0];
    }

    @Override
    public void moveTo(float[] fArray) {
        int n;
        for (n = 0; n < this.numDimensions; ++n) {
            this.position[n] = fArray[n];
            this.baseDim[n] = fArray[n] > 0.0f ? (int)fArray[n] : (int)fArray[n] - 1;
            this.cursor.move(this.baseDim[n] - this.cursor.getPosition(n), n);
        }
        for (n = 0; n < this.numDimensions; ++n) {
            float f;
            this.weights[n][1] = f = fArray[n] - (float)this.baseDim[n];
            this.weights[n][0] = 1.0f - f;
        }
        for (n = 0; n < this.positions.length; ++n) {
            int n2;
            for (n2 = 0; n2 < this.numDimensions; ++n2) {
                if (!this.positions[n][n2]) continue;
                this.cursor.fwd(n2);
            }
            this.tree[this.numDimensions][n].set(this.cursor.getType());
            for (n2 = 0; n2 < this.numDimensions; ++n2) {
                if (!this.positions[n][n2]) continue;
                this.cursor.bck(n2);
            }
        }
        for (n = this.numDimensions; n > 0; --n) {
            for (int i = 0; i < this.halfTreeLevelSizes[n]; ++i) {
                this.tmp1.set(this.tree[n][i * 2]);
                this.tmp2.set(this.tree[n][i * 2 + 1]);
                this.tmp1.mul(this.weights[this.numDimensions - n][0]);
                this.tmp2.mul(this.weights[this.numDimensions - n][1]);
                this.tmp1.add(this.tmp2);
                this.tree[n - 1][i].set(this.tmp1);
            }
        }
    }

    @Override
    public void setPosition(float[] fArray) {
        int n;
        for (n = 0; n < this.numDimensions; ++n) {
            this.position[n] = fArray[n];
            this.baseDim[n] = fArray[n] > 0.0f ? (int)fArray[n] : (int)fArray[n] - 1;
        }
        this.cursor.setPosition(this.baseDim);
        for (n = 0; n < this.numDimensions; ++n) {
            float f;
            this.weights[n][1] = f = fArray[n] - (float)this.baseDim[n];
            this.weights[n][0] = 1.0f - f;
        }
        for (n = 0; n < this.positions.length; ++n) {
            int n2;
            for (n2 = 0; n2 < this.numDimensions; ++n2) {
                if (!this.positions[n][n2]) continue;
                this.cursor.fwd(n2);
            }
            this.tree[this.numDimensions][n].set(this.cursor.getType());
            for (n2 = 0; n2 < this.numDimensions; ++n2) {
                if (!this.positions[n][n2]) continue;
                this.cursor.bck(n2);
            }
        }
        for (n = this.numDimensions; n > 0; --n) {
            for (int i = 0; i < this.halfTreeLevelSizes[n]; ++i) {
                this.tmp1.set(this.tree[n][i * 2]);
                this.tmp2.set(this.tree[n][i * 2 + 1]);
                this.tmp1.mul(this.weights[this.numDimensions - n][0]);
                this.tmp2.mul(this.weights[this.numDimensions - n][1]);
                this.tmp1.add(this.tmp2);
                this.tree[n - 1][i].set(this.tmp1);
            }
        }
    }
}

