/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.lanczos;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.lanczos.LanczosInterpolator;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanczosInterpolatorFactory<T extends RealType<T>>
extends InterpolatorFactory<T> {
    int alpha;
    boolean clipping;

    public LanczosInterpolatorFactory(OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, int n, boolean bl) {
        super(outOfBoundsStrategyFactory);
        this.alpha = n;
        this.clipping = bl;
    }

    public LanczosInterpolatorFactory(OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this(outOfBoundsStrategyFactory, 3, true);
    }

    public void setAlpha(int n) {
        this.alpha = n;
    }

    public void setClipping(boolean bl) {
        this.clipping = bl;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean getClipping() {
        return this.clipping;
    }

    @Override
    public LanczosInterpolator<T> createInterpolator(Image<T> image) {
        return new LanczosInterpolator<T>(image, this, this.outOfBoundsStrategyFactory, this.alpha, this.clipping);
    }
}

