/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.lanczos;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.InterpolatorImpl;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanczosInterpolator<T extends RealType<T>>
extends InterpolatorImpl<T> {
    protected static final float piSquare = (float)(Math.PI * Math.PI);
    final LocalizableByDimCursor<T> cursor;
    final RegionOfInterestCursor<T> roiCursor;
    final float alphaF;
    final int alpha;
    final int numDimensions;
    final T interpolatedValue;
    final int[] offset;
    final int[] size;
    final float minValue;
    final float maxValue;
    final boolean clipping;

    protected LanczosInterpolator(Image<T> image, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, int n, boolean bl) {
        super(image, interpolatorFactory, outOfBoundsStrategyFactory);
        this.alphaF = n;
        this.alpha = n;
        this.numDimensions = image.getNumDimensions();
        this.offset = new int[this.numDimensions];
        this.size = new int[this.numDimensions];
        for (int i = 0; i < this.numDimensions; ++i) {
            this.size[i] = n * 2;
        }
        this.cursor = image.createLocalizableByDimCursor(outOfBoundsStrategyFactory);
        this.roiCursor = new RegionOfInterestCursor<T>(this.cursor, this.offset, this.size);
        this.interpolatedValue = (RealType)image.createType();
        this.clipping = bl;
        this.minValue = (float)this.interpolatedValue.getMinValue();
        this.maxValue = (float)this.interpolatedValue.getMaxValue();
        this.moveTo(this.position);
    }

    @Override
    public T getType() {
        this.roiCursor.reset(this.offset, this.size);
        float f = 0.0f;
        while (this.roiCursor.hasNext()) {
            this.roiCursor.fwd();
            float f2 = 1.0f;
            for (int i = 0; i < this.numDimensions; ++i) {
                f2 *= LanczosInterpolator.sinc(this.position[i] - (float)this.cursor.getPosition(i), this.alphaF);
            }
            f += ((RealType)this.roiCursor.getType()).getRealFloat() * f2;
        }
        if (this.clipping) {
            if (f < this.minValue) {
                f = this.minValue;
            } else if (f > this.maxValue) {
                f = this.maxValue;
            }
            this.interpolatedValue.setReal(f);
        } else {
            this.interpolatedValue.setReal(f);
        }
        return this.interpolatedValue;
    }

    protected static final float sinc(float f, float f2) {
        if (f == 0.0f) {
            return 1.0f;
        }
        return (float)((double)f2 * Math.sin(Math.PI * (double)f) * Math.sin(Math.PI * (double)f / (double)f2) / (double)((float)(Math.PI * Math.PI) * f * f));
    }

    protected static final int floor(float f) {
        return f > 0.0f ? (int)f : (int)f - 1;
    }

    @Override
    public void close() {
    }

    @Override
    public void moveTo(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            float f;
            this.position[i] = f = fArray[i];
            this.offset[i] = LanczosInterpolator.floor(f) - this.alpha + 1;
        }
    }

    @Override
    public void moveRel(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            float f;
            this.position[i] = f = this.position[i] + fArray[i];
            this.offset[i] = LanczosInterpolator.floor(f) - this.alpha + 1;
        }
    }

    @Override
    public void setPosition(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            float f;
            this.position[i] = f = fArray[i];
            this.offset[i] = LanczosInterpolator.floor(f) - this.alpha + 1;
        }
    }
}

