/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.dct;

import java.util.ArrayList;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.InterpolatorImpl;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.label.FakeType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DCTInterpolator<T extends RealType<T>>
extends InterpolatorImpl<T> {
    final Image<FloatType> coefficients;
    final ArrayList<Image<FloatType>> inverseDCT;
    final int numDimensions;
    final T interpolatedValue;

    protected DCTInterpolator(Image<T> image, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(image, interpolatorFactory, outOfBoundsStrategyFactory);
        this.interpolatedValue = (RealType)image.createType();
        this.numDimensions = image.getNumDimensions();
        ImageFactory<FloatType> imageFactory = new ImageFactory<FloatType>(new FloatType(), image.getContainerFactory());
        this.coefficients = imageFactory.createImage(image.getDimensions());
        if (this.numDimensions <= 2) {
            this.inverseDCT = null;
        } else {
            this.inverseDCT = new ArrayList();
            for (int i = 1; i < this.numDimensions - 1; ++i) {
                int[] nArray = new int[i];
                for (int j = 0; j < i; ++j) {
                    nArray[j] = image.getDimension(j);
                }
                this.inverseDCT.add(imageFactory.createImage(nArray));
            }
            this.inverseDCT.add(this.coefficients);
        }
        this.computeCoefficients();
        this.moveTo(this.position);
    }

    public Image<FloatType> getCoefficients() {
        return this.coefficients;
    }

    protected void computeCoefficients() {
        LocalizableByDimCursor localizableByDimCursor = this.img.createLocalizableByDimCursor();
        LocalizableByDimCursor<FloatType> localizableByDimCursor2 = this.coefficients.createLocalizableByDimCursor();
        if (this.numDimensions > 1) {
            int n;
            int[] nArray = new int[this.numDimensions - 1];
            int[] nArray2 = new int[this.numDimensions];
            for (int i = 1; i < this.numDimensions; ++i) {
                nArray[i - 1] = this.img.getDimension(i);
            }
            ArrayLocalizableCursor<FakeType> arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor(nArray);
            int n2 = this.img.getDimension(0);
            float[] fArray = new float[n2];
            float[] fArray2 = new float[n2];
            while (arrayLocalizableCursor.hasNext()) {
                arrayLocalizableCursor.fwd();
                arrayLocalizableCursor.getPosition(nArray);
                nArray2[0] = 0;
                for (n = 1; n < this.numDimensions; ++n) {
                    nArray2[n] = nArray[n - 1];
                }
                localizableByDimCursor.setPosition(nArray2);
                localizableByDimCursor2.setPosition(nArray2);
                for (n = 0; n < n2 - 1; ++n) {
                    fArray[n] = ((RealType)localizableByDimCursor.getType()).getRealFloat();
                    localizableByDimCursor.fwd(0);
                }
                fArray[n2 - 1] = ((RealType)localizableByDimCursor.getType()).getRealFloat();
                DCTInterpolator.computeDCTCoefficients(fArray, fArray2);
                for (n = 0; n < n2 - 1; ++n) {
                    ((FloatType)localizableByDimCursor2.getType()).setReal(fArray2[n]);
                    localizableByDimCursor2.fwd(0);
                }
                ((FloatType)localizableByDimCursor2.getType()).setReal(fArray2[n2 - 1]);
            }
            for (n = 1; n < this.numDimensions; ++n) {
                int n3 = 0;
                for (int i = 0; i < this.numDimensions; ++i) {
                    if (i == n) continue;
                    nArray[n3++] = this.img.getDimension(i);
                }
                ArrayLocalizableCursor<FakeType> arrayLocalizableCursor2 = ArrayLocalizableCursor.createLinearCursor(nArray);
                int n4 = this.img.getDimension(n);
                float[] fArray3 = new float[n4];
                float[] fArray4 = new float[n4];
                while (arrayLocalizableCursor2.hasNext()) {
                    int n5;
                    arrayLocalizableCursor2.fwd();
                    arrayLocalizableCursor2.getPosition(nArray);
                    nArray2[n] = 0;
                    n3 = 0;
                    for (n5 = 0; n5 < this.numDimensions; ++n5) {
                        if (n5 == n) continue;
                        nArray2[n5] = nArray[n3++];
                    }
                    localizableByDimCursor2.setPosition(nArray2);
                    for (n5 = 0; n5 < n4 - 1; ++n5) {
                        fArray3[n5] = ((FloatType)localizableByDimCursor2.getType()).getRealFloat();
                        localizableByDimCursor2.fwd(n);
                    }
                    fArray3[n4 - 1] = ((FloatType)localizableByDimCursor2.getType()).getRealFloat();
                    DCTInterpolator.computeDCTCoefficients(fArray3, fArray4);
                    localizableByDimCursor2.setPosition(nArray2);
                    for (n5 = 0; n5 < n4 - 1; ++n5) {
                        ((FloatType)localizableByDimCursor2.getType()).setReal(fArray4[n5]);
                        localizableByDimCursor2.fwd(n);
                    }
                    ((FloatType)localizableByDimCursor2.getType()).setReal(fArray4[n4 - 1]);
                }
            }
        } else {
            int n;
            int n6 = this.img.getDimension(0);
            float[] fArray = new float[n6];
            float[] fArray5 = new float[n6];
            localizableByDimCursor.setPosition(0, 0);
            localizableByDimCursor2.setPosition(0, 0);
            for (n = 0; n < n6 - 1; ++n) {
                fArray[n] = ((RealType)localizableByDimCursor.getType()).getRealFloat();
                localizableByDimCursor.fwd(0);
            }
            fArray[n6 - 1] = ((RealType)localizableByDimCursor.getType()).getRealFloat();
            DCTInterpolator.computeDCTCoefficients(fArray, fArray5);
            for (n = 0; n < n6 - 1; ++n) {
                ((FloatType)localizableByDimCursor2.getType()).setReal(fArray5[n]);
                localizableByDimCursor.fwd(0);
            }
            ((FloatType)localizableByDimCursor2.getType()).setReal(fArray5[n6 - 1]);
        }
    }

    private static final void computeDCTCoefficients(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray2[i] = 0.0f;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                fArray2[n2] = (float)((double)fArray2[n2] + (double)fArray[j] * Math.cos(Math.PI / (double)n * (double)i * ((double)j + 0.5)));
            }
            if (i == 0) {
                int n3 = i;
                fArray2[n3] = (float)((double)fArray2[n3] * (2.0 / Math.sqrt(2.0) / (double)n));
                continue;
            }
            int n4 = i;
            fArray2[n4] = (float)((double)fArray2[n4] * (2.0 / (double)n));
        }
    }

    private static final float inverseDCT(float[] fArray, float f) {
        int n = fArray.length;
        float f2 = 0.0f;
        f2 = (float)((double)f2 + 1.0 / Math.sqrt(2.0) * (double)fArray[0]);
        for (int i = 1; i < n; ++i) {
            f2 = (float)((double)f2 + (double)fArray[i] * Math.cos(Math.PI / (double)n * (double)i * ((double)f + 0.5)));
        }
        return f2;
    }

    @Override
    public T getType() {
        if (this.numDimensions == 1) {
            LocalizableByDimCursor<FloatType> localizableByDimCursor = this.coefficients.createLocalizableByDimCursor();
            int n = this.img.getDimension(0);
            float[] fArray = new float[n];
            localizableByDimCursor.setPosition(0, 0);
            for (int i = 0; i < n - 1; ++i) {
                fArray[i] = ((FloatType)localizableByDimCursor.getType()).getRealFloat();
                localizableByDimCursor.fwd(0);
            }
            fArray[n - 1] = ((FloatType)localizableByDimCursor.getType()).getRealFloat();
            this.interpolatedValue.setReal(DCTInterpolator.inverseDCT(fArray, this.position[0]));
        } else {
            Image<FloatType> image;
            int n;
            Object object;
            Object object2;
            int n2;
            if (this.numDimensions > 2) {
                for (n2 = this.numDimensions - 1; n2 >= 1; --n2) {
                    Image<FloatType> image2 = this.inverseDCT.get(n2 - 2);
                    object2 = image2.createLocalizableCursor();
                    object = this.inverseDCT.get(n2 - 1);
                    LocalizableByDimCursor localizableByDimCursor = ((Image)object).createLocalizableByDimCursor();
                    int n3 = image2.getNumDimensions();
                    int[] nArray = new int[((Image)object).getNumDimensions()];
                    n = ((Image)object).getDimension(n3);
                    float[] fArray = new float[n];
                    float f = this.position[n2];
                    while (object2.hasNext()) {
                        int n4;
                        object2.fwd();
                        for (n4 = 0; n4 < n3; ++n4) {
                            nArray[n4] = object2.getPosition(n4);
                        }
                        nArray[n3] = 0;
                        localizableByDimCursor.setPosition(nArray);
                        for (n4 = 0; n4 < n - 1; ++n4) {
                            fArray[n4] = ((FloatType)localizableByDimCursor.getType()).getRealFloat();
                            localizableByDimCursor.fwd(n2);
                        }
                        fArray[n - 1] = ((FloatType)localizableByDimCursor.getType()).getRealFloat();
                        ((FloatType)object2.getType()).setReal(DCTInterpolator.inverseDCT(fArray, f));
                    }
                }
                image = this.inverseDCT.get(0);
            } else {
                image = this.coefficients;
            }
            n2 = image.getDimension(0);
            int n5 = image.getDimension(1);
            object2 = new float[n5];
            object = new float[n2];
            float f = this.position[1];
            LocalizableByDimCursor<FloatType> localizableByDimCursor = image.createLocalizableByDimCursor();
            for (int i = 0; i < n2; ++i) {
                localizableByDimCursor.setPosition(i, 0);
                localizableByDimCursor.setPosition(0, 1);
                for (n = 0; n < n5 - 1; ++n) {
                    object2[n] = ((FloatType)localizableByDimCursor.getType()).getRealFloat();
                    localizableByDimCursor.fwd(1);
                }
                object2[n5 - 1] = ((FloatType)localizableByDimCursor.getType()).getRealFloat();
                object[i] = DCTInterpolator.inverseDCT((float[])object2, f);
            }
            this.interpolatedValue.setReal(DCTInterpolator.inverseDCT((float[])object, this.position[0]));
        }
        return this.interpolatedValue;
    }

    @Override
    public void close() {
    }

    @Override
    public void moveTo(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = fArray[i];
        }
    }

    @Override
    public void moveRel(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = i;
            this.position[n] = this.position[n] + fArray[i];
        }
    }

    @Override
    public void setPosition(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = fArray[i];
        }
    }
}

