/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InterpolatorImpl<T extends Type<T>>
implements Interpolator<T> {
    protected final InterpolatorFactory<T> interpolatorFactory;
    protected final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory;
    protected final Image<T> img;
    protected final float[] position;
    protected final float[] tmp;
    protected final int numDimensions;

    protected InterpolatorImpl(Image<T> image, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this.interpolatorFactory = interpolatorFactory;
        this.outOfBoundsStrategyFactory = outOfBoundsStrategyFactory;
        this.img = image;
        this.numDimensions = image.getNumDimensions();
        this.tmp = new float[this.numDimensions];
        this.position = new float[this.numDimensions];
    }

    @Override
    public InterpolatorFactory<T> getInterpolatorFactory() {
        return this.interpolatorFactory;
    }

    @Override
    public OutOfBoundsStrategyFactory<T> getOutOfBoundsStrategyFactory() {
        return this.outOfBoundsStrategyFactory;
    }

    @Override
    public Image<T> getImage() {
        return this.img;
    }

    @Override
    public void getPosition(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            fArray[i] = this.position[i];
        }
    }

    @Override
    public float[] getPosition() {
        return (float[])this.position.clone();
    }

    @Override
    public void moveRel(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.tmp[i] = this.position[i] + fArray[i];
        }
        this.moveTo(this.tmp);
    }
}

