/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display;

import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealTypeDisplay<T extends RealType<T>>
extends Display<T> {
    public RealTypeDisplay(Image<T> image) {
        super(image);
        RealType realType = (RealType)image.createType();
        this.min = realType.getMinValue();
        this.max = realType.getMaxValue();
    }

    @Override
    public void setMinMax() {
        Cursor cursor = this.img.createCursor();
        if (!cursor.hasNext()) {
            RealType realType = (RealType)this.img.createType();
            this.min = realType.getMinValue();
            this.max = realType.getMaxValue();
            return;
        }
        cursor.fwd();
        this.min = this.max = ((RealType)cursor.getType()).getRealDouble();
        while (cursor.hasNext()) {
            cursor.fwd();
            double d = ((RealType)cursor.getType()).getRealDouble();
            if (d > this.max) {
                this.max = d;
                continue;
            }
            if (!(d < this.min)) continue;
            this.min = d;
        }
        cursor.close();
    }

    @Override
    public float get32Bit(T t) {
        return t.getRealFloat();
    }

    @Override
    public float get32BitNormed(T t) {
        return this.normFloat(t.getRealFloat());
    }

    @Override
    public byte get8BitSigned(T t) {
        return (byte)Math.round(this.normFloat(t.getRealFloat()) * 255.0f);
    }

    @Override
    public short get8BitUnsigned(T t) {
        return (short)Math.round(this.normFloat(t.getRealFloat()) * 255.0f);
    }
}

