/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display;

import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.numeric.IntegerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerTypeDisplay<T extends IntegerType<T>>
extends Display<T> {
    public IntegerTypeDisplay(Image<T> image) {
        super(image);
        IntegerType integerType = (IntegerType)image.createType();
        this.min = integerType.getMinValue();
        this.max = integerType.getMaxValue();
    }

    @Override
    public void setMinMax() {
        Cursor cursor = this.img.createCursor();
        if (!cursor.hasNext()) {
            IntegerType integerType = (IntegerType)this.img.createType();
            this.min = integerType.getMinValue();
            this.max = integerType.getMaxValue();
            return;
        }
        cursor.fwd();
        this.min = this.max = (double)((IntegerType)cursor.getType()).getIntegerLong();
        while (cursor.hasNext()) {
            cursor.fwd();
            long l = ((IntegerType)cursor.getType()).getIntegerLong();
            if ((double)l > this.max) {
                this.max = l;
                continue;
            }
            if (!((double)l < this.min)) continue;
            this.min = l;
        }
        cursor.close();
    }

    @Override
    public float get32Bit(T t) {
        return t.getIntegerLong();
    }

    @Override
    public float get32BitNormed(T t) {
        return this.normFloat(t.getIntegerLong());
    }

    @Override
    public byte get8BitSigned(T t) {
        return (byte)Math.round(this.normFloat(t.getIntegerLong()) * 255.0f);
    }

    @Override
    public short get8BitUnsigned(T t) {
        return (short)Math.round(this.normFloat(t.getIntegerLong()) * 255.0f);
    }
}

