/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Display<T extends Type<T>> {
    protected final Image<T> img;
    protected double min;
    protected double max;

    public Display(Image<T> image) {
        this.img = image;
        this.min = 0.0;
        this.max = 1.0;
    }

    public Image<T> getImage() {
        return this.img;
    }

    public abstract void setMinMax();

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double d) {
        this.min = d;
    }

    public void setMax(double d) {
        this.max = d;
    }

    public void setMinMax(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public double normDouble(double d) {
        double d2 = (d - this.min) / (this.max - this.min);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > 1.0) {
            d2 = 1.0;
        }
        return d2;
    }

    public float normFloat(float f) {
        double d = ((double)f - this.min) / (this.max - this.min);
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        return (float)d;
    }

    public abstract float get32Bit(T var1);

    public abstract float get32BitNormed(T var1);

    public abstract byte get8BitSigned(T var1);

    public abstract short get8BitUnsigned(T var1);

    public int get8BitARGB(T t) {
        short s = this.get8BitUnsigned(t);
        return (s << 16) + (s << 8) + s;
    }
}

