/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display;

import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.numeric.ComplexType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexTypePowerSpectrumDisplay<T extends ComplexType<T>>
extends Display<T> {
    public ComplexTypePowerSpectrumDisplay(Image<T> image) {
        super(image);
    }

    @Override
    public void setMinMax() {
        Cursor cursor = this.img.createCursor();
        if (!cursor.hasNext()) {
            this.min = -3.4028234663852886E38;
            this.max = 3.4028234663852886E38;
            return;
        }
        cursor.fwd();
        this.min = this.max = (double)this.getComplexDisplayValue((ComplexType)cursor.getType());
        while (cursor.hasNext()) {
            cursor.fwd();
            double d = this.getComplexDisplayValue((ComplexType)cursor.getType());
            if (d > this.max) {
                this.max = d;
                continue;
            }
            if (!(d < this.min)) continue;
            this.min = d;
        }
        cursor.close();
    }

    protected float getComplexDisplayValue(T t) {
        return t.getPowerFloat();
    }

    @Override
    public float get32Bit(T t) {
        return this.getComplexDisplayValue(t);
    }

    @Override
    public float get32BitNormed(T t) {
        return this.normFloat(this.getComplexDisplayValue(t));
    }

    @Override
    public byte get8BitSigned(T t) {
        return (byte)Math.round(this.normFloat(this.getComplexDisplayValue(t)) * 255.0f);
    }

    @Override
    public short get8BitUnsigned(T t) {
        return (short)Math.round(this.normFloat(this.getComplexDisplayValue(t)) * 255.0f);
    }
}

