/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.ImageProperties;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.cursor.vector.Dimensionality;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image<T extends Type<T>>
implements ImageProperties,
Dimensionality,
Collection<T> {
    protected final ArrayList<Cursor<T>> cursors;
    final ContainerFactory containerFactory;
    final Container<T> container;
    final ImageFactory<T> imageFactory;
    final T type;
    static final AtomicLong i = new AtomicLong();
    static final AtomicLong j = new AtomicLong();
    protected String name;
    protected final float[] calibration;
    protected Display<T> display;

    private Image(Container<T> container, ImageFactory<T> imageFactory, int[] nArray, String string) {
        int n;
        this.name = string == null || string.length() == 0 ? "image" + i.getAndIncrement() : string;
        if (nArray == null || nArray.length < 1) {
            System.err.print("Cannot instantiate Image, dimensions are null. Creating a 1D image of size 1.");
            nArray = new int[]{1};
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] > 0) continue;
            System.err.print("Warning: Image dimension " + (n + 1) + " does not make sense: size=" + nArray[n] + ". Replacing it by 1.");
            nArray[n] = 1;
        }
        this.cursors = new ArrayList();
        this.containerFactory = imageFactory.getContainerFactory();
        this.imageFactory = imageFactory;
        this.type = this.createType();
        this.container = container == null ? this.containerFactory.createContainer(nArray, this.type) : container;
        this.setDefaultDisplay();
        this.calibration = new float[this.getContainer().getNumDimensions()];
        for (n = 0; n < this.getContainer().getNumDimensions(); ++n) {
            this.calibration[n] = 1.0f;
        }
    }

    public Image(Container<T> container, T t) {
        this(container, t, null);
    }

    public Image(Container<T> container, T t, String string) {
        this(container, new ImageFactory<T>(t, container.getFactory()), container.getDimensions(), string);
    }

    protected Image(ImageFactory<T> imageFactory, int[] nArray, String string) {
        this(null, imageFactory, nArray, string);
    }

    public Image<T> createNewImage(int[] nArray, String string) {
        Image<T> image = this.imageFactory.createImage(nArray, string);
        image.setCalibration(this.getCalibration());
        return image;
    }

    public Image<T> createNewImage(int[] nArray) {
        return this.createNewImage(nArray, null);
    }

    public Image<T> createNewImage(String string) {
        return this.createNewImage(this.getContainer().getDimensions(), string);
    }

    public Image<T> createNewImage() {
        return this.createNewImage(this.getContainer().getDimensions(), null);
    }

    public float[] getCalibration() {
        return (float[])this.calibration.clone();
    }

    public float getCalibration(int n) {
        return this.calibration[n];
    }

    public void setCalibration(float[] fArray) {
        for (int i = 0; i < this.getContainer().getNumDimensions(); ++i) {
            this.calibration[i] = fArray[i];
        }
    }

    public void setCalibration(float f, int n) {
        this.calibration[n] = f;
    }

    public Container<T> getContainer() {
        return this.container;
    }

    public T createType() {
        return this.imageFactory.createType();
    }

    public Cursor<T> createCursor() {
        Cursor<T> cursor = this.container.createCursor(this);
        this.addCursor(cursor);
        return cursor;
    }

    public LocalizableCursor<T> createLocalizableCursor() {
        LocalizableCursor<T> localizableCursor = this.container.createLocalizableCursor(this);
        this.addCursor(localizableCursor);
        return localizableCursor;
    }

    public LocalizablePlaneCursor<T> createLocalizablePlaneCursor() {
        LocalizablePlaneCursor<T> localizablePlaneCursor = this.container.createLocalizablePlaneCursor(this);
        this.addCursor(localizablePlaneCursor);
        return localizablePlaneCursor;
    }

    public LocalizableByDimCursor<T> createLocalizableByDimCursor() {
        LocalizableByDimCursor<T> localizableByDimCursor = this.container.createLocalizableByDimCursor(this);
        this.addCursor(localizableByDimCursor);
        return localizableByDimCursor;
    }

    public LocalizableByDimCursor<T> createLocalizableByDimCursor(OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        LocalizableByDimCursor<T> localizableByDimCursor = this.container.createLocalizableByDimCursor(this, outOfBoundsStrategyFactory);
        this.addCursor(localizableByDimCursor);
        return localizableByDimCursor;
    }

    public Interpolator<T> createInterpolator(InterpolatorFactory<T> interpolatorFactory) {
        return interpolatorFactory.createInterpolator(this);
    }

    public void setDefaultDisplay() {
        this.display = this.type.getDefaultDisplay(this);
    }

    public Display<T> getDisplay() {
        return this.display;
    }

    public void setDisplay(Display<T> display) {
        this.display = display;
    }

    public static final synchronized long createUniqueId() {
        return j.getAndIncrement();
    }

    public void close() {
        this.closeAllCursors();
        this.container.close();
    }

    public int[] createPositionArray() {
        return new int[this.getNumDimensions()];
    }

    @Override
    public int getNumDimensions() {
        return this.getContainer().getNumDimensions();
    }

    @Override
    public int[] getDimensions() {
        return this.getContainer().getDimensions();
    }

    @Override
    public int getNumPixels() {
        return this.getContainer().getNumPixels();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return "Image '" + this.getName() + "', dim=" + Util.printCoordinates(this.getContainer().getDimensions());
    }

    @Override
    public void getDimensions(int[] nArray) {
        for (int i = 0; i < this.getContainer().getNumDimensions(); ++i) {
            nArray[i] = this.getContainer().getDimension(i);
        }
    }

    @Override
    public int getDimension(int n) {
        return this.getContainer().getDimension(n);
    }

    public Image<T> clone() {
        Image<T> image = this.createNewImage();
        Cursor<T> cursor = this.createCursor();
        Cursor<T> cursor2 = image.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor2.fwd();
            cursor2.getType().set(cursor.getType());
        }
        cursor.close();
        cursor2.close();
        return image;
    }

    public ContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public ImageFactory<T> getImageFactory() {
        return this.imageFactory;
    }

    public void removeAllCursors() {
        this.closeAllCursors();
        this.cursors.clear();
    }

    public void closeAllCursors() {
        for (Cursor<T> cursor : this.cursors) {
            cursor.close();
        }
    }

    public void getCursors(Collection<Cursor<T>> collection) {
        collection.addAll(this.cursors);
    }

    public ArrayList<Cursor<T>> getCursors() {
        return new ArrayList<Cursor<T>>(this.cursors);
    }

    public ArrayList<Cursor<T>> getActiveCursors() {
        ArrayList<Cursor<T>> arrayList = new ArrayList<Cursor<T>>();
        for (Cursor<T> cursor : this.cursors) {
            if (!cursor.isActive()) continue;
            arrayList.add(cursor);
        }
        return arrayList;
    }

    protected synchronized void addCursor(Cursor<T> cursor) {
        this.cursors.add(cursor);
    }

    protected synchronized void removeCursor(Cursor<T> cursor) {
        cursor.close();
        this.cursors.remove(cursor);
    }

    public int getNumCursors() {
        return this.cursors.size();
    }

    public int getNumActiveCursors() {
        int n = 0;
        for (Cursor<T> cursor : this.cursors) {
            if (!cursor.isActive()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("Image.add(): not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Image.addAll(): not supported.");
    }

    @Override
    public void clear() {
        T t = this.createType();
        for (Type type : this) {
            type.set(t);
        }
    }

    @Override
    public boolean contains(Object object) {
        throw new UnsupportedOperationException("Image.contains(): not supported.");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Image.containsAll(): not supported.");
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.createCursor();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Image.remove(): not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Image.removeAll(): not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Image.retainAll(): not supported.");
    }

    @Override
    public int size() {
        return this.getNumPixels();
    }

    @Override
    public T[] toArray() {
        Type[] typeArray = this.createType().createArray1D(this.getNumPixels());
        ArrayLocalizableCursor<FakeType> arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor(this.getDimensions());
        LocalizableByDimCursor<T> localizableByDimCursor = this.createLocalizableByDimCursor();
        int n = 0;
        while (arrayLocalizableCursor.hasNext()) {
            arrayLocalizableCursor.fwd();
            localizableByDimCursor.moveTo(arrayLocalizableCursor);
            typeArray[n++] = localizableByDimCursor.getType().copy();
        }
        arrayLocalizableCursor.close();
        localizableByDimCursor.close();
        return typeArray;
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        throw new UnsupportedOperationException("Image.toArray<E>(): not supported, use T[] toArray or T[] toArray( T[] a ) instead.");
    }
}

