/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionOfInterestCursor<T extends Type<T>>
extends CursorImpl<T>
implements LocalizableCursor<T> {
    final LocalizableByDimCursor<T> cursor;
    final int[] offset;
    final int[] size;
    final int[] roiPosition;
    final boolean[] currentDirectionDim;
    final int numDimensions;
    final int numPixels;
    final int numPixelsMinus1;
    boolean isActive;
    boolean debug = false;
    int i;

    public RegionOfInterestCursor(LocalizableByDimCursor<T> localizableByDimCursor, int[] nArray, int[] nArray2) {
        super(localizableByDimCursor.getStorageContainer(), localizableByDimCursor.getImage());
        this.offset = (int[])nArray.clone();
        this.size = (int[])nArray2.clone();
        this.cursor = localizableByDimCursor;
        this.numDimensions = localizableByDimCursor.getImage().getNumDimensions();
        this.roiPosition = new int[this.numDimensions];
        this.currentDirectionDim = new boolean[this.numDimensions];
        int n = 1;
        for (int i = 0; i < this.numDimensions; ++i) {
            n *= nArray2[i];
        }
        this.numPixels = n;
        this.numPixelsMinus1 = n - 1;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.i < this.numPixelsMinus1;
    }

    @Override
    public void close() {
        this.isActive = false;
    }

    @Override
    public T getType() {
        return this.cursor.getType();
    }

    public void reset(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.offset[i] = nArray[i];
        }
        this.reset();
    }

    public void reset(int[] nArray, int[] nArray2) {
        int n;
        for (n = 0; n < this.numDimensions; ++n) {
            this.offset[n] = nArray[n];
        }
        if (this.size != null) {
            for (n = 0; n < this.numDimensions; ++n) {
                this.size[n] = nArray2[n];
            }
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.i = -1;
        this.cursor.setPosition(this.offset);
        this.cursor.bck(0);
        for (int i = 0; i < this.numDimensions; ++i) {
            this.currentDirectionDim[i] = true;
            this.roiPosition[i] = 0;
        }
        this.roiPosition[0] = -1;
    }

    @Override
    public void fwd() {
        ++this.i;
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = i;
            if (this.currentDirectionDim[n]) {
                if (this.roiPosition[n] >= this.size[n] - 1) continue;
                this.cursor.fwd(n);
                int n2 = n;
                this.roiPosition[n2] = this.roiPosition[n2] + 1;
                for (int j = 0; j < n; ++j) {
                    this.currentDirectionDim[j] = !this.currentDirectionDim[j];
                }
                return;
            }
            if (this.roiPosition[n] <= 0) continue;
            this.cursor.bck(n);
            int n3 = n;
            this.roiPosition[n3] = this.roiPosition[n3] - 1;
            for (int j = 0; j < n; ++j) {
                this.currentDirectionDim[j] = !this.currentDirectionDim[j];
            }
            return;
        }
    }

    @Override
    public int getArrayIndex() {
        return this.cursor.getArrayIndex();
    }

    @Override
    public int getStorageIndex() {
        return this.cursor.getStorageIndex();
    }

    @Override
    public boolean isActive() {
        return this.cursor.isActive() && this.isActive;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.roiPosition[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.roiPosition.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.roiPosition[n];
    }

    @Override
    public String getPositionAsString() {
        String string = "(" + this.roiPosition[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            string = string + ", " + this.roiPosition[i];
        }
        string = string + ")";
        return string;
    }

    public String toString() {
        return Util.printCoordinates(this.roiPosition) + " [" + Util.printCoordinates(this.cursor.getPosition()) + "] " + this.getType();
    }
}

