/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalNeighborhoodCursor<T extends Type<T>>
extends CursorImpl<T> {
    final ArrayLocalizableCursor<FakeType> neigborhoodCursor;
    final LocalizableByDimCursor<T> cursor;
    final int[] position;
    final int[] tmp;
    final int numDimensions;
    final int centralPositionIndex;
    boolean isActive;
    boolean debug = false;

    public LocalNeighborhoodCursor(LocalizableByDimCursor<T> localizableByDimCursor) {
        super(localizableByDimCursor.getStorageContainer(), localizableByDimCursor.getImage());
        int n;
        this.cursor = localizableByDimCursor;
        this.position = localizableByDimCursor.getPosition();
        this.numDimensions = localizableByDimCursor.getImage().getNumDimensions();
        this.tmp = new int[this.numDimensions];
        int[] nArray = new int[this.numDimensions];
        for (n = 0; n < this.numDimensions; ++n) {
            nArray[n] = 3;
        }
        this.neigborhoodCursor = ArrayLocalizableCursor.createLinearCursor(nArray);
        this.isActive = true;
        for (n = 0; n < this.numDimensions; ++n) {
            nArray[n] = 1;
        }
        this.centralPositionIndex = ((Array)this.neigborhoodCursor.getStorageContainer()).getPos(nArray);
    }

    @Override
    public boolean hasNext() {
        return this.neigborhoodCursor.hasNext();
    }

    @Override
    public void close() {
        this.neigborhoodCursor.close();
        this.isActive = false;
    }

    public void update() {
        this.cursor.getPosition(this.position);
        this.neigborhoodCursor.reset();
    }

    @Override
    public T getType() {
        return this.cursor.getType();
    }

    @Override
    public void reset() {
        this.cursor.setPosition(this.position);
        this.neigborhoodCursor.reset();
    }

    @Override
    public void fwd() {
        this.neigborhoodCursor.fwd();
        if (((FakeType)this.neigborhoodCursor.getType()).getIndex() == this.centralPositionIndex) {
            this.neigborhoodCursor.fwd();
        }
        this.neigborhoodCursor.getPosition(this.tmp);
        for (int i = 0; i < this.numDimensions; ++i) {
            this.tmp[i] = this.position[i] + (this.tmp[i] - 1);
        }
        this.cursor.moveTo(this.tmp);
    }

    public LocalizableByDimCursor<T> getParentCursor() {
        return this.cursor;
    }

    public int getRelativePosition(int n) {
        return this.neigborhoodCursor.getPosition(n);
    }

    @Override
    public int getArrayIndex() {
        return this.cursor.getArrayIndex();
    }

    @Override
    public int getStorageIndex() {
        return this.cursor.getStorageIndex();
    }

    @Override
    public boolean isActive() {
        return this.cursor.isActive() && this.isActive;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

