/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import java.util.Iterator;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.cursor.Iterable;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperSphereIterator<T extends Type<T>>
implements Iterable,
LocalizableCursor<T>,
Localizable {
    protected final Image<T> image;
    protected final Localizable center;
    protected final LocalizableByDimCursor<T> cursor;
    protected int activeCursorIndex;
    protected final int radius;
    protected final int numDimensions;
    protected final int maxDim;
    final int[] r;
    final int[] s;

    public HyperSphereIterator(Image<T> image, Localizable localizable, int n) {
        this(image, localizable, n, null);
    }

    public HyperSphereIterator(Image<T> image, Localizable localizable, int n, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this.image = image;
        this.center = localizable;
        this.radius = n;
        this.numDimensions = image.getNumDimensions();
        this.maxDim = this.numDimensions - 1;
        this.r = new int[this.numDimensions];
        this.s = new int[this.numDimensions];
        this.cursor = outOfBoundsStrategyFactory == null ? image.createLocalizableByDimCursor() : image.createLocalizableByDimCursor(outOfBoundsStrategyFactory);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.s[this.maxDim] > 0;
    }

    @Override
    public void fwd() {
        int n;
        for (n = 0; n < this.numDimensions; ++n) {
            int n2 = n;
            this.s[n2] = this.s[n2] - 1;
            if (this.s[n2] >= 0) {
                this.cursor.fwd(n);
                break;
            }
            this.r[n] = 0;
            this.s[n] = 0;
            this.cursor.setPosition(this.center.getPosition(n), n);
        }
        if (n > 0) {
            int n3 = n - 1;
            int n4 = this.r[n];
            int n5 = n4 - this.s[n];
            int n6 = (int)Math.sqrt(n4 * n4 - n5 * n5);
            this.s[n3] = 2 * n6;
            this.r[n3] = n6;
            this.cursor.setPosition(this.center.getPosition(n3) - n6, n3);
        }
    }

    @Override
    public void reset() {
        int n = this.numDimensions - 1;
        for (int i = 0; i < n; ++i) {
            this.s[i] = 0;
            this.r[i] = 0;
            this.cursor.setPosition(this.center.getPosition(i), i);
        }
        this.cursor.setPosition(this.center.getPosition(n) - this.radius - 1, n);
        this.r[n] = this.radius;
        this.s[n] = 1 + 2 * this.radius;
    }

    @Override
    public void fwd(long l) {
        for (long i = 0L; i < l; ++i) {
            this.fwd();
        }
    }

    @Override
    public void getPosition(int[] nArray) {
        this.cursor.getPosition(nArray);
    }

    @Override
    public int[] getPosition() {
        return this.cursor.getPosition();
    }

    @Override
    public int getPosition(int n) {
        return this.cursor.getPosition(n);
    }

    @Override
    public String getPositionAsString() {
        return this.cursor.getPositionAsString();
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public int[] createPositionArray() {
        return this.cursor.createPositionArray();
    }

    @Override
    public int getArrayIndex() {
        return this.cursor.getArrayIndex();
    }

    @Override
    public Image<T> getImage() {
        return this.image;
    }

    @Override
    public Container<T> getStorageContainer() {
        return this.cursor.getStorageContainer();
    }

    @Override
    public int getStorageIndex() {
        return this.cursor.getStorageIndex();
    }

    @Override
    public T getType() {
        return this.cursor.getType();
    }

    @Override
    public boolean isActive() {
        return this.cursor.isActive();
    }

    @Override
    public void setDebug(boolean bl) {
    }

    @Override
    public T next() {
        this.fwd();
        return this.getType();
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<T> iterator() {
        this.reset();
        return this;
    }

    @Override
    public int[] getDimensions() {
        return this.image.getDimensions();
    }

    @Override
    public void getDimensions(int[] nArray) {
        this.image.getDimensions(nArray);
    }

    @Override
    public int getNumDimensions() {
        return this.image.getNumDimensions();
    }
}

