/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.shapelist;

import mpicbg.imglib.container.shapelist.ShapeList;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.shapelist.ShapeListLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeListLocalizablePlaneCursor<T extends Type<T>>
extends ShapeListLocalizableByDimCursor<T>
implements LocalizablePlaneCursor<T> {
    protected int planeDimA;
    protected int planeDimB;

    public ShapeListLocalizablePlaneCursor(ShapeList<T> shapeList, Image<T> image) {
        super(shapeList, image);
    }

    @Override
    public boolean hasNext() {
        int n = this.dimensions[this.planeDimB] - 1;
        if (this.position[this.planeDimB] < n) {
            return true;
        }
        if (this.position[this.planeDimB] > n) {
            return false;
        }
        int n2 = this.dimensions[this.planeDimA] - 1;
        return this.position[this.planeDimA] < n2;
    }

    @Override
    public void fwd() {
        int n = this.planeDimA;
        this.position[n] = this.position[n] + 1;
        if (this.position[n] >= this.dimensions[this.planeDimA]) {
            this.position[this.planeDimA] = 0;
            int n2 = this.planeDimB;
            this.position[n2] = this.position[n2] + 1;
        }
    }

    @Override
    public void reset(int n, int n2, int[] nArray) {
        this.planeDimA = n;
        this.planeDimB = n2;
        this.setPosition(nArray);
        this.position[n] = -1;
        this.position[n] = 0;
    }

    @Override
    public void reset(int n, int n2) {
        if (this.dimensions == null) {
            return;
        }
        this.reset(n, n2, new int[this.numDimensions]);
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.reset(0, 1, new int[this.numDimensions]);
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    @Override
    public void setPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
        }
    }
}

