/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.shapelist;

import mpicbg.imglib.container.shapelist.ShapeList;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.shapelist.ShapeListLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeListLocalizableByDimOutOfBoundsCursor<T extends Type<T>>
extends ShapeListLocalizableByDimCursor<T>
implements LocalizableByDimCursor<T> {
    final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory;
    final OutOfBoundsStrategy<T> outOfBoundsStrategy;
    boolean isOutOfBounds = false;

    public ShapeListLocalizableByDimOutOfBoundsCursor(ShapeList<T> shapeList, Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(shapeList, image);
        this.outOfBoundsStrategyFactory = outOfBoundsStrategyFactory;
        this.outOfBoundsStrategy = outOfBoundsStrategyFactory.createStrategy(this);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (this.isOutOfBounds) {
            return false;
        }
        for (int i = this.numDimensions - 1; i >= 0; --i) {
            int n = this.dimensions[i] - 1;
            if (this.position[i] >= n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        if (this.outOfBoundsStrategy == null) {
            return;
        }
        this.isClosed = false;
        this.isOutOfBounds = false;
        super.reset();
    }

    @Override
    public T getType() {
        if (this.isOutOfBounds) {
            return this.outOfBoundsStrategy.getType();
        }
        return super.getType();
    }

    @Override
    public void fwd() {
        if (!this.isOutOfBounds) {
            for (int i = 0; i < this.numDimensions; ++i) {
                int n = i;
                this.position[n] = this.position[n] + 1;
                if (this.position[n] < this.dimensions[i]) {
                    return;
                }
                this.position[i] = 0;
            }
            this.isOutOfBounds = true;
            this.position[0] = this.position[0] + 1;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void fwd(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] + 1;
        if (this.isOutOfBounds) {
            if (this.position[n] == 0) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(n);
            }
        } else if (this.position[n] >= this.dimensions[n]) {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void move(int n, int n2) {
        int n3 = n2;
        this.position[n3] = this.position[n3] + n;
        if (this.isOutOfBounds) {
            if (this.position[n2] >= 0 && this.position[n2] < this.dimensions[n2]) {
                this.isOutOfBounds = false;
                for (int i = 0; i < this.numDimensions && !this.isOutOfBounds; ++i) {
                    this.isOutOfBounds = this.position[i] < 0 || this.position[i] >= this.dimensions[i];
                }
                if (this.isOutOfBounds) {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(n, n2);
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(n, n2);
            }
        } else if (this.position[n2] < 0 || this.position[n2] >= this.dimensions[n2]) {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void bck(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] - 1;
        if (this.isOutOfBounds) {
            if (this.position[n] < this.dimensions[n]) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(n);
            }
        } else if (this.position[n] == -1) {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPosition(int[] nArray) {
        boolean bl = this.isOutOfBounds;
        this.isOutOfBounds = false;
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
            if (nArray[i] >= 0 && nArray[i] < this.dimensions[i]) continue;
            this.isOutOfBounds = true;
        }
        if (this.isOutOfBounds) {
            if (bl) {
                this.outOfBoundsStrategy.notifyOutOfBOunds();
            } else {
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void setPosition(int n, int n2) {
        this.position[n2] = n;
        if (this.isOutOfBounds) {
            this.setPosition(this.position);
        } else if (n < 0 || n >= this.dimensions[n2]) {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
            return;
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        this.moveTo(localizable.getPosition());
    }

    @Override
    public void setPosition(Localizable localizable) {
        this.setPosition(localizable.getPosition());
    }
}

