/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.shapelist;

import mpicbg.imglib.container.shapelist.ShapeList;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeListLocalizableByDimCursor<T extends Type<T>>
extends CursorImpl<T>
implements LocalizableByDimCursor<T> {
    private int numNeighborhoodCursors = 0;
    protected final ShapeList<T> container;
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;

    public ShapeListLocalizableByDimCursor(ShapeList<T> shapeList, Image<T> image) {
        super(shapeList, image);
        this.container = shapeList;
        this.numDimensions = shapeList.getNumDimensions();
        this.position = new int[this.numDimensions];
        this.dimensions = shapeList.getDimensions();
        this.position[0] = -1;
    }

    @Override
    public T getType() {
        return this.container.getShapeType(this.position);
    }

    @Override
    public synchronized LocalNeighborhoodCursor<T> createLocalNeighborhoodCursor() {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(this);
        }
        System.out.println("ShapeListLocalizableByDimCursor.createLocalNeighborhoodCursor(): There is only one one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public synchronized RegionOfInterestCursor<T> createRegionOfInterestCursor(int[] nArray, int[] nArray2) {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return new RegionOfInterestCursor(this, nArray, nArray2);
        }
        System.out.println("ShapeListLocalizableByDimCursor.createRegionOfInterestCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public void fwd(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] + 1;
    }

    @Override
    public void move(int n, int n2) {
        int n3 = n2;
        this.position[n3] = this.position[n3] + n;
    }

    @Override
    public void bck(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] - 1;
    }

    @Override
    public void moveRel(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.move(nArray[i], i);
        }
    }

    @Override
    public void moveTo(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = nArray[i] - this.getPosition(i);
            if (n == 0) continue;
            this.move(n, i);
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        localizable.getPosition(this.position);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.getPosition(this.position);
    }

    @Override
    public void setPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
        }
    }

    @Override
    public void setPosition(int n, int n2) {
        this.position[n2] = n;
    }

    @Override
    public void close() {
    }

    @Override
    public int getStorageIndex() {
        return 0;
    }

    @Override
    public void reset() {
        this.position[0] = -1;
        for (int i = 1; i < this.numDimensions; ++i) {
            this.position[i] = 0;
        }
    }

    @Override
    public boolean hasNext() {
        for (int i = this.numDimensions - 1; i >= 0; --i) {
            int n = this.dimensions[i] - 1;
            if (this.position[i] < n) {
                return true;
            }
            if (this.position[i] <= n) continue;
            return false;
        }
        return false;
    }

    @Override
    public void fwd() {
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = i;
            this.position[n] = this.position[n] + 1;
            if (this.position[n] < this.dimensions[i]) break;
            this.position[i] = 0;
        }
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    @Override
    public String getPositionAsString() {
        String string = "(" + this.position[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            string = string + ", " + this.position[i];
        }
        string = string + ")";
        return string;
    }
}

