/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarLocalizablePlaneCursor<T extends Type<T>>
extends PlanarLocalizableCursor<T>
implements LocalizablePlaneCursor<T> {
    private int xIndex;
    private int yIndex;
    private int xSize;
    private int ySize;
    private int pos;
    private int maxPos;
    private final int[] sliceSteps;
    private int width;
    private int planeSize;

    public PlanarLocalizablePlaneCursor(PlanarContainer<T, ?> planarContainer, Image<T> image, T t) {
        super(planarContainer, image, t, false);
        this.sliceSteps = new int[this.numDimensions + 1];
        if (this.sliceSteps.length > 2) {
            this.sliceSteps[2] = 1;
            for (int i = 3; i < this.sliceSteps.length; ++i) {
                int n = i - 1;
                this.sliceSteps[i] = this.dimensions[n] * this.sliceSteps[n];
            }
        }
        this.width = image.getDimension(0);
        this.planeSize = this.width * image.getDimension(1);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.maxPos;
    }

    @Override
    public void fwd() {
        ++this.pos;
        boolean bl = false;
        int n = this.xIndex;
        this.position[n] = this.position[n] + 1;
        if (this.position[n] == this.xSize) {
            this.position[this.xIndex] = 0;
            switch (this.xIndex) {
                case 0: {
                    this.type.decIndex(this.width - 1);
                    break;
                }
                case 1: {
                    this.type.decIndex(this.planeSize - 1);
                    break;
                }
                default: {
                    this.sliceIndex -= this.sliceSteps[this.xIndex + 1] - 1;
                    bl = true;
                }
            }
            int n2 = this.yIndex;
            this.position[n2] = this.position[n2] + 1;
            switch (this.yIndex) {
                case 0: {
                    this.type.incIndex();
                    break;
                }
                case 1: {
                    this.type.incIndex(this.width);
                    break;
                }
                default: {
                    this.sliceIndex += this.sliceSteps[this.yIndex];
                    bl = true;
                    break;
                }
            }
        } else {
            switch (this.xIndex) {
                case 0: {
                    this.type.incIndex();
                    break;
                }
                case 1: {
                    this.type.incIndex(this.width);
                    break;
                }
                default: {
                    this.sliceIndex += this.sliceSteps[this.xIndex];
                    bl = true;
                }
            }
        }
        if (bl) {
            this.type.updateContainer(this);
        }
    }

    @Override
    public void reset(int n, int n2, int[] nArray) {
        this.xIndex = n;
        this.yIndex = n2;
        int[] nArray2 = (int[])nArray.clone();
        nArray2[n] = 0;
        nArray2[n2] = 0;
        this.setPosition(nArray2);
        this.xSize = this.image.getDimension(n);
        this.ySize = this.image.getDimension(n2);
        this.maxPos = this.xSize * this.ySize;
        this.pos = 0;
        this.isClosed = false;
        switch (n) {
            case 0: {
                this.type.decIndex();
                break;
            }
            case 1: {
                this.type.decIndex(-this.width);
                break;
            }
            default: {
                this.sliceIndex -= this.sliceSteps[n];
            }
        }
        this.position[n] = -1;
    }

    @Override
    public void reset(int n, int n2) {
        if (this.dimensions == null) {
            return;
        }
        this.reset(n, n2, new int[this.numDimensions]);
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.reset(0, 1, new int[this.numDimensions]);
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    private void setPosition(int[] nArray) {
        int n;
        this.type.updateIndex(this.container.getIndex(nArray));
        for (n = 0; n < this.numDimensions; ++n) {
            this.position[n] = nArray[n];
        }
        this.sliceIndex = 0;
        for (n = 2; n < this.numDimensions; ++n) {
            this.sliceIndex += nArray[n] * this.sliceSteps[n];
        }
        this.type.updateContainer(this);
    }
}

