/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.planar.PlanarCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarLocalizableCursor<T extends Type<T>>
extends PlanarCursor<T>
implements LocalizableCursor<T> {
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;

    public PlanarLocalizableCursor(PlanarContainer<T, ?> planarContainer, Image<T> image, T t) {
        this(planarContainer, image, t, true);
    }

    PlanarLocalizableCursor(PlanarContainer<T, ?> planarContainer, Image<T> image, T t, boolean bl) {
        super(planarContainer, image, t);
        this.numDimensions = planarContainer.getNumDimensions();
        this.position = new int[this.numDimensions];
        this.dimensions = planarContainer.getDimensions();
        if (bl) {
            this.reset();
        }
    }

    @Override
    public void fwd() {
        super.fwd();
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = i;
            this.position[n] = this.position[n] + 1;
            if (this.position[n] < this.dimensions[i]) {
                return;
            }
            this.position[i] = 0;
        }
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.isClosed = false;
        this.type.updateIndex(-1);
        this.position[0] = -1;
        for (int i = 1; i < this.numDimensions; ++i) {
            this.position[i] = 0;
        }
        this.sliceIndex = 0;
        this.type.updateContainer(this);
        this.hasNext = true;
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    @Override
    public String getPositionAsString() {
        String string = "(" + this.position[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            string = string + ", " + this.position[i];
        }
        string = string + ")";
        return string;
    }

    @Override
    public String toString() {
        return this.getPositionAsString() + " = " + this.getType();
    }
}

