/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarLocalizableByDimOutOfBoundsCursor<T extends Type<T>>
extends PlanarLocalizableByDimCursor<T>
implements LocalizableByDimCursor<T> {
    final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory;
    final OutOfBoundsStrategy<T> outOfBoundsStrategy;
    boolean isOutOfBounds = false;

    public PlanarLocalizableByDimOutOfBoundsCursor(PlanarContainer<T, ?> planarContainer, Image<T> image, T t, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(planarContainer, image, t);
        this.outOfBoundsStrategyFactory = outOfBoundsStrategyFactory;
        this.outOfBoundsStrategy = outOfBoundsStrategyFactory.createStrategy(this);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return !this.isOutOfBounds && (this.type.getIndex() < this.lastIndex || this.sliceIndex < this.lastSliceIndex);
    }

    @Override
    public T getType() {
        if (this.isOutOfBounds) {
            return this.outOfBoundsStrategy.getType();
        }
        return (T)this.type;
    }

    @Override
    public void reset() {
        if (this.outOfBoundsStrategy == null) {
            return;
        }
        this.isClosed = false;
        this.isOutOfBounds = false;
        this.type.updateIndex(-1);
        this.position[0] = -1;
        this.sliceIndex = 0;
        for (int i = 1; i < this.numDimensions; ++i) {
            this.position[i] = 0;
        }
        this.type.updateContainer(this);
    }

    @Override
    public void fwd() {
        if (!this.isOutOfBounds) {
            int n;
            this.type.incIndex();
            if (this.type.getIndex() > this.lastIndex) {
                ++this.sliceIndex;
                this.type.updateIndex(0);
                this.type.updateContainer(this);
            }
            for (n = 0; n < this.numDimensions; ++n) {
                int n2 = n;
                this.position[n2] = this.position[n2] + 1;
                if (this.position[n2] < this.dimensions[n]) break;
                this.position[n] = 0;
            }
            if (n == this.numDimensions) {
                this.isOutOfBounds = true;
                this.position[0] = this.position[0] + 1;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void fwd(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] + 1;
        if (this.isOutOfBounds) {
            if (this.position[n] == 0) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(n);
            }
        } else if (this.position[n] < this.dimensions[n]) {
            if (n > 1) {
                this.sliceIndex += this.sliceSteps[n];
                this.type.updateContainer(this);
            } else {
                this.type.incIndex(this.step[n]);
            }
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void move(int n, int n2) {
        int n3 = n2;
        this.position[n3] = this.position[n3] + n;
        if (this.isOutOfBounds) {
            if (this.position[n2] >= 0 && this.position[n2] < this.dimensions[n2]) {
                int n4;
                this.isOutOfBounds = false;
                for (n4 = 0; n4 < this.numDimensions && !this.isOutOfBounds; ++n4) {
                    this.isOutOfBounds = this.position[n4] < 0 || this.position[n4] >= this.dimensions[n4];
                }
                if (!this.isOutOfBounds) {
                    this.type.updateIndex(this.container.getIndex(this.position));
                    this.sliceIndex = 0;
                    for (n4 = 2; n4 < this.numDimensions; ++n4) {
                        this.sliceIndex += this.position[n4] * this.sliceSteps[n4];
                    }
                    this.type.updateContainer(this);
                } else {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(n, n2);
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(n, n2);
            }
        } else if (this.position[n2] >= 0 && this.position[n2] < this.dimensions[n2]) {
            if (n2 > 1) {
                this.sliceIndex += n * this.sliceSteps[n2];
                this.type.updateContainer(this);
            } else {
                this.type.incIndex(this.step[n2] * n);
            }
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void bck(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] - 1;
        if (this.isOutOfBounds) {
            if (this.position[n] == this.dimensions[n] - 1) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(n);
            }
        } else if (this.position[n] > -1) {
            if (n > 1) {
                this.sliceIndex -= this.sliceSteps[n];
                this.type.updateContainer(this);
            } else {
                this.type.decIndex(this.step[n]);
            }
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPosition(int[] nArray) {
        int n;
        boolean bl = this.isOutOfBounds;
        this.isOutOfBounds = false;
        for (n = 0; n < this.numDimensions; ++n) {
            this.position[n] = nArray[n];
            if (nArray[n] >= 0 && nArray[n] < this.dimensions[n]) continue;
            this.isOutOfBounds = true;
        }
        if (this.isOutOfBounds) {
            if (bl) {
                this.outOfBoundsStrategy.notifyOutOfBOunds();
            } else {
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        } else {
            this.type.updateIndex(this.container.getIndex(nArray));
            this.sliceIndex = 0;
            for (n = 2; n < this.numDimensions; ++n) {
                this.sliceIndex += nArray[n] * this.sliceSteps[n];
            }
            this.type.updateContainer(this);
        }
    }

    @Override
    public void setPosition(int n, int n2) {
        this.position[n2] = n;
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(this.position);
        } else {
            if (n < 0 || n >= this.dimensions[n2]) {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
                return;
            }
            if (n2 > 1) {
                this.sliceIndex = n * this.sliceSteps[n2];
                this.type.updateContainer(this);
            } else {
                this.type.updateIndex(this.container.getIndex(this.position));
            }
        }
    }
}

