/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarLocalizableByDimCursor<T extends Type<T>>
extends PlanarLocalizableCursor<T>
implements LocalizableByDimCursor<T> {
    protected final int[] step;
    protected final int[] tmp;
    protected final int[] sliceSteps;
    int numNeighborhoodCursors = 0;

    public PlanarLocalizableByDimCursor(PlanarContainer<T, ?> planarContainer, Image<T> image, T t) {
        super(planarContainer, image, t);
        int[] nArray = planarContainer.getDimensions();
        this.step = Array.createAllocationSteps(nArray);
        this.sliceSteps = new int[nArray.length];
        if (nArray.length > 2) {
            this.sliceSteps[2] = 1;
            for (int i = 3; i < nArray.length; ++i) {
                int n = i - 1;
                this.sliceSteps[i] = nArray[n] * this.sliceSteps[n];
            }
        }
        this.tmp = new int[this.numDimensions];
    }

    @Override
    public synchronized LocalNeighborhoodCursor<T> createLocalNeighborhoodCursor() {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(this);
        }
        System.err.println(this.getClass().getCanonicalName() + ".createLocalNeighborhoodCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public synchronized RegionOfInterestCursor<T> createRegionOfInterestCursor(int[] nArray, int[] nArray2) {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return new RegionOfInterestCursor(this, nArray, nArray2);
        }
        System.err.println(this.getClass().getCanonicalName() + ".createRegionOfInterestCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public void fwd(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] + 1;
        if (n > 1) {
            this.sliceIndex += this.sliceSteps[n];
            this.type.updateContainer(this);
        } else {
            this.type.incIndex(this.step[n]);
        }
    }

    @Override
    public void move(int n, int n2) {
        int n3 = n2;
        this.position[n3] = this.position[n3] + n;
        if (n2 > 1) {
            this.sliceIndex += this.sliceSteps[n2] * n;
            this.type.updateContainer(this);
        } else {
            this.type.incIndex(this.step[n2] * n);
        }
    }

    @Override
    public void moveRel(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.move(nArray[i], i);
        }
    }

    @Override
    public void moveTo(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = nArray[i] - this.getPosition(i);
            if (n == 0) continue;
            this.move(n, i);
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.moveTo(this.tmp);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.setPosition(this.tmp);
    }

    @Override
    public void bck(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] - 1;
        if (n > 1) {
            this.sliceIndex -= this.sliceSteps[n];
            this.type.updateContainer(this);
        } else {
            this.type.decIndex(this.step[n]);
        }
    }

    @Override
    public void setPosition(int[] nArray) {
        int n;
        this.type.updateIndex(this.container.getIndex(nArray));
        for (n = 0; n < this.numDimensions; ++n) {
            this.position[n] = nArray[n];
        }
        this.sliceIndex = 0;
        for (n = 2; n < this.numDimensions; ++n) {
            this.sliceIndex += nArray[n] * this.sliceSteps[n];
        }
        this.type.updateContainer(this);
    }

    @Override
    public void setPosition(int n, int n2) {
        this.position[n2] = n;
        if (n2 > 1) {
            this.sliceIndex = n * this.sliceSteps[n2];
            this.type.updateContainer(this);
        } else {
            this.type.updateIndex(this.container.getIndex(this.position));
        }
    }
}

