/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarCursor<T extends Type<T>>
extends CursorImpl<T> {
    protected final T type;
    protected final PlanarContainer<T, ?> container;
    protected final int lastIndex;
    protected final int lastSliceIndex;
    protected int sliceIndex;
    protected boolean hasNext;

    public PlanarCursor(PlanarContainer<T, ?> planarContainer, Image<T> image, T t) {
        super(planarContainer, image);
        this.type = t;
        this.container = planarContainer;
        this.lastIndex = planarContainer.getDimension(0) * planarContainer.getDimension(1) - 1;
        this.lastSliceIndex = planarContainer.getSlices() - 1;
        this.reset();
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void fwd() {
        this.type.incIndex();
        int n = this.type.getIndex();
        if (n < this.lastIndex) {
            return;
        }
        if (n == this.lastIndex) {
            this.hasNext = this.sliceIndex < this.lastSliceIndex;
        } else {
            ++this.sliceIndex;
            this.type.updateIndex(0);
            this.type.updateContainer(this);
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.type.updateIndex(this.lastIndex + 1);
        this.sliceIndex = this.lastSliceIndex + 1;
    }

    @Override
    public void reset() {
        this.sliceIndex = 0;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
        this.isClosed = false;
        this.hasNext = true;
    }

    public PlanarContainer<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int getStorageIndex() {
        return this.sliceIndex;
    }

    public String toString() {
        return this.type.toString();
    }
}

