/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.dynamic;

import mpicbg.imglib.container.dynamic.DynamicContainer;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicLocalizablePlaneCursor<T extends Type<T>>
extends DynamicLocalizableCursor<T>
implements LocalizablePlaneCursor<T> {
    protected int planeDimA;
    protected int planeDimB;
    protected int planeSizeA;
    protected int planeSizeB;
    protected int incPlaneA;
    protected int incPlaneB;
    protected int maxI;

    public DynamicLocalizablePlaneCursor(DynamicContainer<T, ?> dynamicContainer, Image<T> image, T t) {
        super(dynamicContainer, image, t);
    }

    @Override
    public boolean hasNext() {
        return this.internalIndex < this.maxI;
    }

    @Override
    public void fwd() {
        if (this.position[this.planeDimA] < this.dimensions[this.planeDimA] - 1) {
            int n = this.planeDimA;
            this.position[n] = this.position[n] + 1;
            this.internalIndex += this.incPlaneA;
        } else if (this.position[this.planeDimB] < this.dimensions[this.planeDimB] - 1) {
            this.position[this.planeDimA] = 0;
            int n = this.planeDimB;
            this.position[n] = this.position[n] + 1;
            this.internalIndex += this.incPlaneB;
            this.internalIndex -= (this.planeSizeA - 1) * this.incPlaneA;
        }
        this.accessor.updateIndex(this.internalIndex);
    }

    @Override
    public void reset(int n, int n2, int[] nArray) {
        this.planeDimA = n;
        this.planeDimB = n2;
        this.planeSizeA = this.container.getDimension(n);
        this.planeSizeB = this.container.getDimension(n2);
        int[] nArray2 = this.container.getSteps();
        int[] nArray3 = (int[])nArray.clone();
        this.incPlaneA = nArray2[n];
        nArray3[n] = 0;
        if (n2 > -1 && n2 < nArray2.length) {
            this.incPlaneB = nArray2[n2];
            nArray3[n2] = 0;
        } else {
            this.incPlaneB = 0;
        }
        this.setPosition(nArray3);
        this.isClosed = false;
        this.type.updateContainer(this);
        this.internalIndex -= this.incPlaneA;
        this.position[n] = -1;
        nArray3[n] = this.dimensions[n] - 1;
        if (n2 > -1 && n2 < nArray2.length) {
            nArray3[n2] = this.dimensions[n2] - 1;
        }
        this.maxI = this.container.getPos(nArray3);
    }

    @Override
    public void reset(int n, int n2) {
        if (this.dimensions == null) {
            return;
        }
        this.reset(n, n2, new int[this.numDimensions]);
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.reset(0, 1, this.image.createPositionArray());
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    protected void setPosition(int[] nArray) {
        this.internalIndex = this.container.getPos(nArray);
        this.type.updateContainer(this);
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
        }
    }
}

