/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.dynamic;

import mpicbg.imglib.container.dynamic.DynamicContainer;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.dynamic.DynamicCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicLocalizableCursor<T extends Type<T>>
extends DynamicCursor<T>
implements LocalizableCursor<T> {
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;

    public DynamicLocalizableCursor(DynamicContainer<T, ?> dynamicContainer, Image<T> image, T t) {
        super(dynamicContainer, image, t);
        this.numDimensions = dynamicContainer.getNumDimensions();
        this.position = image.createPositionArray();
        this.dimensions = dynamicContainer.getDimensions();
        this.reset();
    }

    @Override
    public void fwd() {
        ++this.internalIndex;
        this.accessor.updateIndex(this.internalIndex);
        for (int i = 0; i < this.numDimensions; ++i) {
            if (this.position[i] >= this.dimensions[i] - 1) continue;
            int n = i;
            this.position[n] = this.position[n] + 1;
            for (int j = 0; j < i; ++j) {
                this.position[j] = 0;
            }
            return;
        }
    }

    @Override
    public void fwd(long l) {
        for (long i = 0L; i < l; ++i) {
            this.fwd();
        }
    }

    @Override
    public boolean hasNext() {
        return this.internalIndex < this.container.getNumPixels() - 1;
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.type.updateIndex(0);
        this.internalIndex = 0;
        this.type.updateContainer(this);
        this.accessor.updateIndex(this.internalIndex);
        this.internalIndex = -1;
        this.isClosed = false;
        this.position[0] = -1;
        for (int i = 1; i < this.numDimensions; ++i) {
            this.position[i] = 0;
        }
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    @Override
    public String getPositionAsString() {
        String string = "(" + this.position[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            string = string + ", " + this.position[i];
        }
        string = string + ")";
        return string;
    }

    @Override
    public String toString() {
        return this.getPositionAsString() + " = " + this.getType();
    }
}

