/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.dynamic;

import mpicbg.imglib.container.dynamic.DynamicContainer;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizableCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicLocalizableByDimCursor<T extends Type<T>>
extends DynamicLocalizableCursor<T>
implements LocalizableByDimCursor<T> {
    protected final int[] step;
    final int[] tmp;
    int numNeighborhoodCursors = 0;

    public DynamicLocalizableByDimCursor(DynamicContainer<T, ?> dynamicContainer, Image<T> image, T t) {
        super(dynamicContainer, image, t);
        this.step = dynamicContainer.getSteps();
        this.tmp = new int[this.numDimensions];
    }

    @Override
    public synchronized LocalNeighborhoodCursor<T> createLocalNeighborhoodCursor() {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(this);
        }
        System.out.println("ArrayLocalizableByDimCursor.createLocalNeighborhoodCursor(): There is only one one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public synchronized RegionOfInterestCursor<T> createRegionOfInterestCursor(int[] nArray, int[] nArray2) {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return new RegionOfInterestCursor(this, nArray, nArray2);
        }
        System.out.println("ArrayLocalizableByDimCursor.createRegionOfInterestCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public void fwd(int n) {
        this.internalIndex += this.step[n];
        this.accessor.updateIndex(this.internalIndex);
        int n2 = n;
        this.position[n2] = this.position[n2] + 1;
    }

    @Override
    public void move(int n, int n2) {
        this.internalIndex += this.step[n2] * n;
        this.accessor.updateIndex(this.internalIndex);
        int n3 = n2;
        this.position[n3] = this.position[n3] + n;
    }

    @Override
    public void bck(int n) {
        this.internalIndex -= this.step[n];
        this.accessor.updateIndex(this.internalIndex);
        int n2 = n;
        this.position[n2] = this.position[n2] - 1;
    }

    @Override
    public void moveRel(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.move(nArray[i], i);
        }
    }

    @Override
    public void moveTo(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = nArray[i] - this.getPosition(i);
            if (n == 0) continue;
            this.move(n, i);
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.moveTo(this.tmp);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.setPosition(this.tmp);
    }

    @Override
    public void setPosition(int[] nArray) {
        this.internalIndex = this.container.getPos(nArray);
        this.accessor.updateIndex(this.internalIndex);
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
        }
    }

    @Override
    public void setPosition(int n, int n2) {
        this.position[n2] = n;
        this.internalIndex = this.container.getPos(this.position);
        this.accessor.updateIndex(this.internalIndex);
    }
}

