/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.dynamic;

import mpicbg.imglib.container.basictypecontainer.DataAccess;
import mpicbg.imglib.container.dynamic.DynamicContainer;
import mpicbg.imglib.container.dynamic.DynamicContainerAccessor;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicCursor<T extends Type<T>>
extends CursorImpl<T>
implements Cursor<T> {
    protected final T type;
    protected final DynamicContainer<T, ? extends DataAccess> container;
    protected final DynamicContainerAccessor accessor;
    int internalIndex;

    public DynamicCursor(DynamicContainer<T, ? extends DynamicContainerAccessor> dynamicContainer, Image<T> image, T t) {
        super(dynamicContainer, image);
        this.type = t;
        this.container = dynamicContainer;
        this.accessor = dynamicContainer.createAccessor();
        this.reset();
    }

    public DynamicContainerAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.internalIndex < this.container.getNumPixels() - 1;
    }

    @Override
    public void fwd(long l) {
        this.internalIndex = (int)((long)this.internalIndex + l);
        this.accessor.updateIndex(this.internalIndex);
    }

    @Override
    public void fwd() {
        ++this.internalIndex;
        this.accessor.updateIndex(this.internalIndex);
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.internalIndex = Integer.MAX_VALUE;
    }

    @Override
    public void reset() {
        this.type.updateIndex(0);
        this.internalIndex = 0;
        this.type.updateContainer(this);
        this.accessor.updateIndex(this.internalIndex);
        this.internalIndex = -1;
        this.isClosed = false;
    }

    public int getInternalIndex() {
        return this.internalIndex;
    }

    public DynamicContainer<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int getStorageIndex() {
        return this.internalIndex;
    }

    public String toString() {
        return this.type.toString();
    }
}

