/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.cell;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellLocalizablePlaneCursor<T extends Type<T>>
extends CellLocalizableCursor<T>
implements LocalizablePlaneCursor<T> {
    final ArrayLocalizableByDimCursor<FakeType> cursor;
    protected int maxCellsPlane;
    protected int currentCellsPlane;
    protected int planeDimA;
    protected int planeDimB;
    protected int planeSizeA;
    protected int planeSizeB;
    protected int incPlaneA;
    protected int incPlaneB;
    protected final int[] step;
    protected final int[] cellPosition;
    protected final int[] tmp;
    protected final int[] cellEnd;
    protected final int[] numCellsDim;
    protected final int[] cellStep;

    public CellLocalizablePlaneCursor(CellContainer<T, ?> cellContainer, Image<T> image, T t) {
        super(cellContainer, image, t);
        this.step = new int[this.numDimensions];
        this.cellPosition = new int[this.numDimensions];
        this.cellEnd = new int[this.numDimensions];
        this.tmp = new int[this.numDimensions];
        this.numCellsDim = cellContainer.getNumCellsDim();
        this.cellStep = new int[this.numDimensions];
        this.cursor = ArrayLocalizableByDimCursor.createLinearByDimCursor(this.numCellsDim);
        this.cursor.setPosition(new int[cellContainer.getNumDimensions()]);
        Array.createAllocationSteps(this.numCellsDim, this.cellStep);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (this.currentCellsPlane < this.maxCellsPlane - 1) {
            return true;
        }
        return this.type.getIndex() < this.cellMaxI;
    }

    @Override
    public void fwd() {
        if (this.type.getIndex() < this.cellMaxI) {
            if (this.type.getIndex() == -1 || this.position[this.planeDimA] < this.cellEnd[this.planeDimA] - 1) {
                int n = this.planeDimA;
                this.position[n] = this.position[n] + 1;
                this.type.incIndex(this.incPlaneA);
            } else {
                this.position[this.planeDimA] = this.cellOffset[this.planeDimA];
                int n = this.planeDimB;
                this.position[n] = this.position[n] + 1;
                this.type.incIndex(this.incPlaneB);
                this.type.decIndex((this.planeSizeA - 1) * this.incPlaneA);
            }
        } else if (this.currentCellsPlane < this.maxCellsPlane - 1) {
            ++this.currentCellsPlane;
            if (this.cellPosition[this.planeDimA] < this.numCellsDim[this.planeDimA] - 1) {
                int n = this.planeDimA;
                this.cellPosition[n] = this.cellPosition[n] + 1;
            } else if (this.cellPosition[this.planeDimB] < this.numCellsDim[this.planeDimB] - 1) {
                this.cellPosition[this.planeDimA] = 0;
                int n = this.planeDimB;
                this.cellPosition[n] = this.cellPosition[n] + 1;
            }
            this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
            this.getCellData(this.cell);
            this.position[this.planeDimA] = this.cellOffset[this.planeDimA];
            if (this.planeDimB < this.numDimensions) {
                this.position[this.planeDimB] = this.cellOffset[this.planeDimB];
            }
            this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
        }
    }

    @Override
    protected void getCellData(int n) {
        int n2;
        if (n == this.lastCell) {
            return;
        }
        this.lastCell = n;
        this.cellInstance = this.container.getCell(n);
        this.cellInstance.getDimensions(this.cellDimensions);
        this.cellInstance.getOffset(this.cellOffset);
        this.planeSizeA = this.cellDimensions[this.planeDimA];
        if (this.planeDimB < this.numDimensions) {
            this.planeSizeB = this.cellDimensions[this.planeDimB];
        } else {
            this.planeDimB = 1;
        }
        for (n2 = 0; n2 < this.numDimensions; ++n2) {
            this.cellEnd[n2] = this.cellOffset[n2] + this.cellDimensions[n2];
        }
        this.cellInstance.getSteps(this.step);
        for (n2 = 0; n2 < this.numDimensions; ++n2) {
            this.tmp[n2] = this.position[n2];
        }
        this.incPlaneA = this.step[this.planeDimA];
        this.tmp[this.planeDimA] = this.cellEnd[this.planeDimA] - 1;
        if (this.planeDimB > -1 && this.planeDimB < this.step.length) {
            this.tmp[this.planeDimB] = this.cellEnd[this.planeDimB] - 1;
            this.incPlaneB = this.step[this.planeDimB];
        } else {
            this.incPlaneB = 0;
        }
        this.cellMaxI = this.cellInstance.getPosGlobal(this.tmp);
        this.type.updateContainer(this);
    }

    @Override
    public void reset(int n, int n2, int[] nArray) {
        this.lastCell = -1;
        this.planeDimA = n;
        this.planeDimB = n2;
        this.maxCellsPlane = this.container.getNumCells(n) * this.container.getNumCells(n2);
        this.currentCellsPlane = 0;
        int[] nArray2 = (int[])nArray.clone();
        nArray2[n] = 0;
        if (n2 > -1 && n2 < this.step.length) {
            nArray2[n2] = 0;
        }
        this.setPosition(nArray2);
        this.isClosed = false;
        this.position[n] = -1;
        this.type.decIndex(this.incPlaneA);
    }

    @Override
    public void reset(int n, int n2) {
        this.reset(n, n2, new int[this.numDimensions]);
    }

    @Override
    public void reset() {
        if (this.step == null) {
            return;
        }
        this.reset(0, 1, new int[this.numDimensions]);
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    protected void setPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
        }
        this.container.getCellPosition(nArray, this.cellPosition);
        this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
        this.getCellData(this.cell);
        this.type.updateIndex(this.cellInstance.getPosGlobal(nArray));
    }

    @Override
    public void close() {
        this.cursor.close();
        if (!this.isClosed) {
            this.lastCell = -1;
            this.isClosed = true;
        }
    }
}

