/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.cell;

import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.cell.CellCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellLocalizableCursor<T extends Type<T>>
extends CellCursor<T>
implements LocalizableCursor<T> {
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;
    protected final int[] cellDimensions;
    protected final int[] cellOffset;

    public CellLocalizableCursor(CellContainer<T, ?> cellContainer, Image<T> image, T t) {
        super(cellContainer, image, t);
        this.numDimensions = cellContainer.getNumDimensions();
        this.position = new int[this.numDimensions];
        this.dimensions = cellContainer.getDimensions();
        this.cellDimensions = new int[this.numDimensions];
        this.cellOffset = new int[this.numDimensions];
        this.reset();
    }

    @Override
    protected void getCellData(int n) {
        if (n == this.lastCell) {
            return;
        }
        this.lastCell = n;
        this.cellInstance = this.container.getCell(n);
        this.cellMaxI = this.cellInstance.getNumPixels();
        this.cellInstance.getDimensions(this.cellDimensions);
        this.cellInstance.getOffset(this.cellOffset);
        this.type.updateContainer(this);
    }

    @Override
    public void reset() {
        if (this.position == null) {
            return;
        }
        this.type.updateIndex(-1);
        this.cell = 0;
        this.getCellData(this.cell);
        this.isClosed = false;
        this.position[0] = -1;
        for (int i = 1; i < this.numDimensions; ++i) {
            this.position[i] = 0;
        }
        this.type.updateContainer(this);
    }

    @Override
    public void fwd() {
        if (this.type.getIndex() < this.cellMaxI - 1) {
            this.type.incIndex();
            for (int i = 0; i < this.numDimensions; ++i) {
                if (this.position[i] >= this.cellDimensions[i] + this.cellOffset[i] - 1) continue;
                int n = i;
                this.position[n] = this.position[n] + 1;
                for (int j = 0; j < i; ++j) {
                    this.position[j] = this.cellOffset[j];
                }
                break;
            }
        } else if (this.cell < this.numCells - 1) {
            ++this.cell;
            this.type.updateIndex(0);
            this.getCellData(this.cell);
            for (int i = 0; i < this.numDimensions; ++i) {
                this.position[i] = this.cellOffset[i];
            }
        } else {
            this.lastCell = -1;
            this.type.updateIndex(this.cellMaxI);
            this.cell = this.numCells;
        }
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    @Override
    public String getPositionAsString() {
        String string = "(" + this.position[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            string = string + ", " + this.position[i];
        }
        string = string + ")";
        return string;
    }

    @Override
    public String toString() {
        return this.getPositionAsString() + " = " + this.getType();
    }
}

