/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.cell;

import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellLocalizableByDimOutOfBoundsCursor<T extends Type<T>>
extends CellLocalizableByDimCursor<T>
implements LocalizableByDimCursor<T> {
    final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory;
    final OutOfBoundsStrategy<T> outOfBoundsStrategy;
    boolean isOutOfBounds = false;

    public CellLocalizableByDimOutOfBoundsCursor(CellContainer<T, ?> cellContainer, Image<T> image, T t, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(cellContainer, image, t);
        this.outOfBoundsStrategyFactory = outOfBoundsStrategyFactory;
        this.outOfBoundsStrategy = outOfBoundsStrategyFactory.createStrategy(this);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (!this.isOutOfBounds && this.cell < this.numCells - 1) {
            return true;
        }
        return this.type.getIndex() < this.cellMaxI - 1;
    }

    @Override
    public T getType() {
        if (this.isOutOfBounds) {
            return this.outOfBoundsStrategy.getType();
        }
        return (T)this.type;
    }

    @Override
    public void reset() {
        if (this.outOfBoundsStrategy == null) {
            return;
        }
        this.type.updateIndex(-1);
        this.cell = 0;
        this.getCellData(this.cell);
        this.isClosed = false;
        this.isOutOfBounds = false;
        this.position[0] = -1;
        this.cellPosition[0] = 0;
        for (int i = 1; i < this.numDimensions; ++i) {
            this.position[i] = 0;
            this.cellPosition[i] = 0;
        }
        this.cursor.setPosition(this.cellPosition);
        this.type.updateContainer(this);
    }

    @Override
    public void fwd() {
        if (!this.isOutOfBounds) {
            if (this.type.getIndex() < this.cellMaxI - 1) {
                this.type.incIndex();
                for (int i = 0; i < this.numDimensions; ++i) {
                    if (this.position[i] >= this.cellDimensions[i] + this.cellOffset[i] - 1) continue;
                    int n = i;
                    this.position[n] = this.position[n] + 1;
                    for (int j = 0; j < i; ++j) {
                        this.position[j] = this.cellOffset[j];
                    }
                    return;
                }
            } else if (this.cell < this.numCells - 1) {
                ++this.cell;
                this.type.updateIndex(0);
                this.getCellData(this.cell);
                for (int i = 0; i < this.numDimensions; ++i) {
                    this.position[i] = this.cellOffset[i];
                }
                this.container.getCellPosition(this.position, this.cellPosition);
                this.cursor.setPosition(this.cellPosition);
            } else {
                this.isOutOfBounds = true;
                this.lastCell = -1;
                this.cell = this.numCells;
                this.position[0] = this.position[0] + 1;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void move(int n, int n2) {
        if (this.isOutOfBounds) {
            int n3 = n2;
            this.position[n3] = this.position[n3] + n;
            if (this.position[n2] >= 0 && this.position[n2] < this.dimensions[n2]) {
                this.isOutOfBounds = false;
                for (int i = 0; i < this.numDimensions && !this.isOutOfBounds; ++i) {
                    if (this.position[i] >= 0 && this.position[i] < this.dimensions[i]) continue;
                    this.isOutOfBounds = true;
                }
                if (!this.isOutOfBounds) {
                    this.type.updateContainer(this);
                    this.container.getCellPosition(this.position, this.cellPosition);
                    this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
                    this.getCellData(this.cell);
                    this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
                } else {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(n, n2);
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(n, n2);
            }
        } else {
            int n4 = n2;
            this.position[n4] = this.position[n4] + n;
            if (this.position[n2] < this.cellEnd[n2] && this.position[n2] >= this.cellOffset[n2]) {
                this.type.incIndex(this.step[n2] * n);
            } else {
                this.setPosition(this.position[n2], n2);
            }
        }
    }

    @Override
    public void fwd(int n) {
        if (this.isOutOfBounds) {
            int n2 = n;
            this.position[n2] = this.position[n2] + 1;
            if (this.position[n] == 0) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(n);
            }
        } else if (this.position[n] + 1 < this.cellEnd[n]) {
            this.type.incIndex(this.step[n]);
            int n3 = n;
            this.position[n3] = this.position[n3] + 1;
        } else if (this.cellPosition[n] < this.numCellsDim[n] - 2) {
            this.cursor.fwd(n);
            int n4 = n;
            this.cellPosition[n4] = this.cellPosition[n4] + 1;
            this.cell += this.cellStep[n];
            this.type.decIndex((this.position[n] - this.cellOffset[n]) * this.step[n]);
            this.getCellData(this.cell);
            int n5 = n;
            this.position[n5] = this.position[n5] + 1;
        } else if (this.cellPosition[n] == this.numCellsDim[n] - 2) {
            this.cursor.fwd(n);
            int n6 = n;
            this.cellPosition[n6] = this.cellPosition[n6] + 1;
            this.cell += this.cellStep[n];
            this.getCellData(this.cell);
            int n7 = n;
            this.position[n7] = this.position[n7] + 1;
            this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
        } else {
            this.isOutOfBounds = true;
            this.lastCell = -1;
            this.cell = this.numCells;
            int n8 = n;
            this.position[n8] = this.position[n8] + 1;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void bck(int n) {
        if (this.isOutOfBounds) {
            int n2 = n;
            this.position[n2] = this.position[n2] - 1;
            if (this.position[n] == this.dimensions[n] - 1) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(n);
            }
        } else if (this.position[n] - 1 >= this.cellOffset[n]) {
            this.type.decIndex(this.step[n]);
            int n3 = n;
            this.position[n3] = this.position[n3] - 1;
        } else if (this.cellPosition[n] == this.numCellsDim[n] - 1 && this.numCells != 1) {
            this.cursor.bck(n);
            int n4 = n;
            this.cellPosition[n4] = this.cellPosition[n4] - 1;
            this.cell -= this.cellStep[n];
            this.getCellData(this.cell);
            int n5 = n;
            this.position[n5] = this.position[n5] - 1;
            this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
        } else if (this.cellPosition[n] > 0) {
            this.cursor.bck(n);
            int n6 = n;
            this.cellPosition[n6] = this.cellPosition[n6] - 1;
            this.cell -= this.cellStep[n];
            this.type.decIndex((this.position[n] - this.cellOffset[n]) * this.step[n]);
            this.getCellData(this.cell);
            this.type.incIndex((this.cellDimensions[n] - 1) * this.step[n]);
            int n7 = n;
            this.position[n7] = this.position[n7] - 1;
        } else {
            this.isOutOfBounds = true;
            this.lastCell = -1;
            this.cell = this.numCells;
            int n8 = n;
            this.position[n8] = this.position[n8] - 1;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPosition(int[] nArray) {
        boolean bl = this.isOutOfBounds;
        this.isOutOfBounds = false;
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
            if (nArray[i] >= 0 && nArray[i] < this.dimensions[i]) continue;
            this.isOutOfBounds = true;
        }
        if (this.isOutOfBounds) {
            if (bl) {
                this.outOfBoundsStrategy.notifyOutOfBOunds();
            } else {
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        } else {
            if (bl) {
                this.type.updateContainer(this);
            }
            this.container.getCellPosition(nArray, this.cellPosition);
            this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
            this.getCellData(this.cell);
            this.type.updateIndex(this.cellInstance.getPosGlobal(nArray));
        }
    }

    @Override
    public void setPosition(int n, int n2) {
        this.position[n2] = n;
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(this.position);
        } else {
            if (n < 0 || n >= this.dimensions[n2]) {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
                return;
            }
            this.cellPosition[n2] = this.container.getCellPosition(n, n2);
            this.cell = this.container.getCellIndex(this.cursor, this.cellPosition[n2], n2);
            this.getCellData(this.cell);
            this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
        }
    }
}

