/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.cell;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellLocalizableByDimCursor<T extends Type<T>>
extends CellLocalizableCursor<T>
implements LocalizableByDimCursor<T> {
    final ArrayLocalizableByDimCursor<FakeType> cursor;
    protected final int numCells;
    protected final int[] numCellsDim;
    protected final int[] cellPosition;
    protected final int[] cellEnd;
    protected final int[] step;
    protected final int[] cellStep;
    int numNeighborhoodCursors = 0;
    final int[] tmp;

    public CellLocalizableByDimCursor(CellContainer<T, ?> cellContainer, Image<T> image, T t) {
        super(cellContainer, image, t);
        this.numCells = cellContainer.getNumCells();
        this.numCellsDim = cellContainer.getNumCellsDim();
        this.cellPosition = new int[this.numDimensions];
        this.cellEnd = new int[this.numDimensions];
        this.step = new int[this.numDimensions];
        this.cellStep = new int[this.numDimensions];
        this.tmp = new int[this.numDimensions];
        this.cursor = ArrayLocalizableByDimCursor.createLinearByDimCursor(this.numCellsDim);
        this.cursor.setPosition(new int[cellContainer.getNumDimensions()]);
        Array.createAllocationSteps(this.numCellsDim, this.cellStep);
        this.reset();
    }

    @Override
    protected void getCellData(int n) {
        if (n == this.lastCell) {
            return;
        }
        this.lastCell = n;
        this.cellInstance = this.container.getCell(n);
        this.cellMaxI = this.cellInstance.getNumPixels();
        this.cellInstance.getDimensions(this.cellDimensions);
        this.cellInstance.getOffset(this.cellOffset);
        for (int i = 0; i < this.numDimensions; ++i) {
            this.cellEnd[i] = this.cellOffset[i] + this.cellDimensions[i];
        }
        this.cellInstance.getSteps(this.step);
        this.type.updateContainer(this);
    }

    @Override
    public synchronized LocalNeighborhoodCursor<T> createLocalNeighborhoodCursor() {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(this);
        }
        System.out.println("CellLocalizableByDimCursor.createLocalNeighborhoodCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public synchronized RegionOfInterestCursor<T> createRegionOfInterestCursor(int[] nArray, int[] nArray2) {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return new RegionOfInterestCursor(this, nArray, nArray2);
        }
        System.out.println("CellLocalizableByDimCursor.createRegionOfInterestCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public void fwd() {
        if (this.type.getIndex() < this.cellMaxI - 1) {
            this.type.incIndex();
            for (int i = 0; i < this.numDimensions; ++i) {
                if (this.position[i] >= this.cellDimensions[i] + this.cellOffset[i] - 1) continue;
                int n = i;
                this.position[n] = this.position[n] + 1;
                for (int j = 0; j < i; ++j) {
                    this.position[j] = this.cellOffset[j];
                }
                break;
            }
        } else if (this.cell < this.numCells - 1) {
            ++this.cell;
            this.type.updateIndex(0);
            this.getCellData(this.cell);
            for (int i = 0; i < this.numDimensions; ++i) {
                this.position[i] = this.cellOffset[i];
            }
            this.container.getCellPosition(this.position, this.cellPosition);
            this.cursor.setPosition(this.cellPosition);
        } else {
            this.lastCell = -1;
            this.type.updateIndex(this.cellMaxI);
            this.cell = this.numCells;
        }
    }

    @Override
    public void reset() {
        if (this.cellEnd == null) {
            return;
        }
        this.type.updateIndex(-1);
        this.cell = 0;
        this.getCellData(this.cell);
        this.isClosed = false;
        this.position[0] = -1;
        this.cellPosition[0] = 0;
        for (int i = 1; i < this.numDimensions; ++i) {
            this.position[i] = 0;
            this.cellPosition[i] = 0;
        }
        this.cursor.setPosition(this.cellPosition);
        this.type.updateContainer(this);
    }

    @Override
    public void fwd(int n) {
        if (this.position[n] + 1 < this.cellEnd[n]) {
            this.type.incIndex(this.step[n]);
            int n2 = n;
            this.position[n2] = this.position[n2] + 1;
        } else {
            this.cursor.fwd(n);
            if (this.cellPosition[n] < this.numCellsDim[n] - 2) {
                int n3 = n;
                this.cellPosition[n3] = this.cellPosition[n3] + 1;
                this.cell += this.cellStep[n];
                this.type.decIndex((this.position[n] - this.cellOffset[n]) * this.step[n]);
                this.getCellData(this.cell);
                int n4 = n;
                this.position[n4] = this.position[n4] + 1;
            } else {
                int n5 = n;
                this.cellPosition[n5] = this.cellPosition[n5] + 1;
                this.cell += this.cellStep[n];
                this.getCellData(this.cell);
                int n6 = n;
                this.position[n6] = this.position[n6] + 1;
                this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
            }
        }
    }

    @Override
    public void move(int n, int n2) {
        int n3 = n2;
        this.position[n3] = this.position[n3] + n;
        if (this.position[n2] < this.cellEnd[n2] && this.position[n2] >= this.cellOffset[n2]) {
            this.type.incIndex(this.step[n2] * n);
        } else {
            this.setPosition(this.position[n2], n2);
        }
    }

    @Override
    public void moveRel(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.move(nArray[i], i);
        }
    }

    @Override
    public void moveTo(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = nArray[i] - this.getPosition(i);
            if (n == 0) continue;
            this.move(n, i);
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.moveTo(this.tmp);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.setPosition(this.tmp);
    }

    @Override
    public void bck(int n) {
        if (this.position[n] - 1 >= this.cellOffset[n]) {
            this.type.decIndex(this.step[n]);
            int n2 = n;
            this.position[n2] = this.position[n2] - 1;
        } else {
            this.cursor.bck(n);
            if (this.cellPosition[n] == this.numCellsDim[n] - 1 && this.numCells != 1) {
                int n3 = n;
                this.cellPosition[n3] = this.cellPosition[n3] - 1;
                this.cell -= this.cellStep[n];
                this.getCellData(this.cell);
                int n4 = n;
                this.position[n4] = this.position[n4] - 1;
                this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
            } else {
                int n5 = n;
                this.cellPosition[n5] = this.cellPosition[n5] - 1;
                this.cell -= this.cellStep[n];
                this.type.decIndex((this.position[n] - this.cellOffset[n]) * this.step[n]);
                this.getCellData(this.cell);
                this.type.incIndex((this.cellDimensions[n] - 1) * this.step[n]);
                int n6 = n;
                this.position[n6] = this.position[n6] - 1;
            }
        }
    }

    @Override
    public void setPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
        }
        this.container.getCellPosition(nArray, this.cellPosition);
        this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
        this.getCellData(this.cell);
        this.type.updateIndex(this.cellInstance.getPosGlobal(nArray));
    }

    @Override
    public void setPosition(int n, int n2) {
        this.position[n2] = n;
        this.cellPosition[n2] = this.container.getCellPosition(n, n2);
        this.cell = this.container.getCellIndex(this.cursor, this.cellPosition[n2], n2);
        this.getCellData(this.cell);
        this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
    }

    @Override
    public void close() {
        this.cursor.close();
        if (!this.isClosed) {
            this.lastCell = -1;
            this.isClosed = true;
        }
    }
}

