/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.cell;

import mpicbg.imglib.container.cell.Cell;
import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellCursor<T extends Type<T>>
extends CursorImpl<T>
implements Cursor<T> {
    protected final T type;
    protected final CellContainer<T, ?> container;
    protected final int numCells;
    protected int cell;
    protected int lastCell;
    protected int cellMaxI;
    protected Cell<T, ?> cellInstance;

    public CellCursor(CellContainer<T, ?> cellContainer, Image<T> image, T t) {
        super(cellContainer, image);
        this.type = t;
        this.container = cellContainer;
        this.numCells = cellContainer.getNumCells();
        this.lastCell = -1;
        this.reset();
    }

    protected void getCellData(int n) {
        if (n == this.lastCell) {
            return;
        }
        this.lastCell = n;
        this.cellInstance = this.container.getCell(n);
        this.cellMaxI = this.cellInstance.getNumPixels();
        this.type.updateContainer(this);
    }

    public Cell<T, ?> getCurrentCell() {
        return this.cellInstance;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public void reset() {
        this.type.updateIndex(-1);
        this.cell = 0;
        this.getCellData(this.cell);
        this.isClosed = false;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.lastCell = -1;
            this.isClosed = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.cell < this.numCells - 1) {
            return true;
        }
        return this.type.getIndex() < this.cellMaxI - 1;
    }

    @Override
    public void fwd() {
        if (this.type.getIndex() < this.cellMaxI - 1) {
            this.type.incIndex();
        } else {
            ++this.cell;
            this.type.updateIndex(0);
            this.getCellData(this.cell);
        }
    }

    public CellContainer<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int getStorageIndex() {
        return this.cellInstance.getCellId();
    }

    public String toString() {
        return this.type.toString();
    }
}

