/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayLocalizablePlaneCursor<T extends Type<T>>
extends ArrayLocalizableCursor<T>
implements LocalizablePlaneCursor<T> {
    protected int planeDimA;
    protected int planeDimB;
    protected int planeSizeA;
    protected int planeSizeB;
    protected int incPlaneA;
    protected int incPlaneB;
    protected int maxI;

    public ArrayLocalizablePlaneCursor(Array<T, ?> array, Image<T> image, T t) {
        super(array, image, t);
    }

    @Override
    public boolean hasNext() {
        return this.type.getIndex() < this.maxI;
    }

    @Override
    public void fwd() {
        if (this.position[this.planeDimA] < this.dimensions[this.planeDimA] - 1) {
            int n = this.planeDimA;
            this.position[n] = this.position[n] + 1;
            this.type.incIndex(this.incPlaneA);
        } else if (this.position[this.planeDimB] < this.dimensions[this.planeDimB] - 1) {
            this.position[this.planeDimA] = 0;
            int n = this.planeDimB;
            this.position[n] = this.position[n] + 1;
            this.type.incIndex(this.incPlaneB);
            this.type.decIndex((this.planeSizeA - 1) * this.incPlaneA);
        }
    }

    @Override
    public void reset(int n, int n2, int[] nArray) {
        this.planeDimA = n;
        this.planeDimB = n2;
        this.planeSizeA = this.container.getDimension(n);
        this.planeSizeB = this.container.getDimension(n2);
        int[] nArray2 = Array.createAllocationSteps(this.container.getDimensions());
        int[] nArray3 = (int[])nArray.clone();
        this.incPlaneA = nArray2[n];
        nArray3[n] = 0;
        if (n2 > -1 && n2 < nArray2.length) {
            this.incPlaneB = nArray2[n2];
            nArray3[n2] = 0;
        } else {
            this.incPlaneB = 0;
        }
        this.setPosition(nArray3);
        this.isClosed = false;
        this.type.decIndex(this.incPlaneA);
        this.position[n] = -1;
        nArray3[n] = this.dimensions[n] - 1;
        if (n2 > -1 && n2 < nArray2.length) {
            nArray3[n2] = this.dimensions[n2] - 1;
        }
        this.maxI = this.container.getPos(nArray3);
        this.type.updateContainer(this);
    }

    @Override
    public void reset(int n, int n2) {
        if (this.dimensions == null) {
            return;
        }
        this.reset(n, n2, new int[this.numDimensions]);
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.reset(0, 1, new int[this.numDimensions]);
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    protected void setPosition(int[] nArray) {
        this.type.updateIndex(this.container.getPos(nArray));
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
        }
    }
}

